/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class LinedBoxPanel
extends JPanel {
    private final boolean horizontal;
    private int spacing = 6;
    private boolean needsSpacer = false;

    public LinedBoxPanel(boolean horizontal) {
        this.horizontal = horizontal;
        this.setLayout(new BoxLayout(this, horizontal ? 0 : 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
    }

    public LinedBoxPanel fullyPadded() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return this;
    }

    public void addElement(Component component) {
        if (this.needsSpacer) {
            this.add(this.horizontal ? Box.createHorizontalStrut(this.spacing) : Box.createVerticalStrut(this.spacing));
        }
        this.add(component);
        this.needsSpacer = true;
    }

    public void addGlue() {
        this.add(this.horizontal ? Box.createHorizontalGlue() : Box.createVerticalGlue());
        this.needsSpacer = false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }
}

