/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch;

import com.google.common.base.Preconditions;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.launch.LaunchListener;
import java.awt.Window;

public class LaunchOptions {
    private final Window window;
    private final Instance instance;
    private final UpdatePolicy updatePolicy;
    private final LaunchListener listener;
    private final Session session;

    public LaunchOptions(Window window, Instance instance, UpdatePolicy updatePolicy, LaunchListener listener, Session session) {
        this.window = window;
        this.instance = instance;
        this.updatePolicy = updatePolicy;
        this.listener = listener;
        this.session = session;
    }

    public Window getWindow() {
        return this.window;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public LaunchListener getListener() {
        return this.listener;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LaunchOptions)) {
            return false;
        }
        LaunchOptions other = (LaunchOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Window this$window = this.getWindow();
        Window other$window = other.getWindow();
        if (this$window == null ? other$window != null : !this$window.equals(other$window)) {
            return false;
        }
        Instance this$instance = this.getInstance();
        Instance other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
            return false;
        }
        UpdatePolicy this$updatePolicy = this.getUpdatePolicy();
        UpdatePolicy other$updatePolicy = other.getUpdatePolicy();
        if (this$updatePolicy == null ? other$updatePolicy != null : !((Object)((Object)this$updatePolicy)).equals((Object)other$updatePolicy)) {
            return false;
        }
        LaunchListener this$listener = this.getListener();
        LaunchListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        Session this$session = this.getSession();
        Session other$session = other.getSession();
        return !(this$session == null ? other$session != null : !this$session.equals(other$session));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LaunchOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Window $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : $window.hashCode());
        Instance $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        UpdatePolicy $updatePolicy = this.getUpdatePolicy();
        result = result * 59 + ($updatePolicy == null ? 43 : ((Object)((Object)$updatePolicy)).hashCode());
        LaunchListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        Session $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        return result;
    }

    public String toString() {
        return "LaunchOptions(window=" + this.getWindow() + ", instance=" + this.getInstance() + ", updatePolicy=" + (Object)((Object)this.getUpdatePolicy()) + ", listener=" + this.getListener() + ", session=" + this.getSession() + ")";
    }

    private static class DummyLaunchListener
    implements LaunchListener {
        private DummyLaunchListener() {
        }

        @Override
        public void instancesUpdated() {
        }

        @Override
        public void gameStarted() {
        }

        @Override
        public void gameClosed() {
        }
    }

    public static enum UpdatePolicy {
        NO_UPDATE(false),
        UPDATE_IF_SESSION_ONLINE(true),
        ALWAYS_UPDATE(true);

        private final boolean updateEnabled;

        private UpdatePolicy(boolean updateEnabled) {
            this.updateEnabled = updateEnabled;
        }

        public boolean isUpdateEnabled() {
            return this.updateEnabled;
        }
    }

    public static class Builder {
        private Window window = null;
        private Instance instance;
        private UpdatePolicy updatePolicy = UpdatePolicy.UPDATE_IF_SESSION_ONLINE;
        private LaunchListener listener = new DummyLaunchListener();
        private Session session;

        public Builder setWindow(Window window) {
            this.window = window;
            return this;
        }

        public Builder setInstance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public Builder setUpdatePolicy(UpdatePolicy updatePolicy) {
            Preconditions.checkNotNull(updatePolicy, "updatePolicy");
            this.updatePolicy = updatePolicy;
            return this;
        }

        public Builder setListener(LaunchListener listener) {
            Preconditions.checkNotNull(listener, "listener");
            this.listener = listener;
            return this;
        }

        public Builder setSession(Session session) {
            this.session = session;
            return this;
        }

        public LaunchOptions build() {
            Preconditions.checkNotNull(this.instance, "instance");
            return new LaunchOptions(this.window, this.instance, this.updatePolicy, this.listener, this.session);
        }

        public Window getWindow() {
            return this.window;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public UpdatePolicy getUpdatePolicy() {
            return this.updatePolicy;
        }

        public LaunchListener getListener() {
            return this.listener;
        }

        public Session getSession() {
            return this.session;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Window this$window = this.getWindow();
            Window other$window = other.getWindow();
            if (this$window == null ? other$window != null : !this$window.equals(other$window)) {
                return false;
            }
            Instance this$instance = this.getInstance();
            Instance other$instance = other.getInstance();
            if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
                return false;
            }
            UpdatePolicy this$updatePolicy = this.getUpdatePolicy();
            UpdatePolicy other$updatePolicy = other.getUpdatePolicy();
            if (this$updatePolicy == null ? other$updatePolicy != null : !((Object)((Object)this$updatePolicy)).equals((Object)other$updatePolicy)) {
                return false;
            }
            LaunchListener this$listener = this.getListener();
            LaunchListener other$listener = other.getListener();
            if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
                return false;
            }
            Session this$session = this.getSession();
            Session other$session = other.getSession();
            return !(this$session == null ? other$session != null : !this$session.equals(other$session));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Window $window = this.getWindow();
            result = result * 59 + ($window == null ? 43 : $window.hashCode());
            Instance $instance = this.getInstance();
            result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
            UpdatePolicy $updatePolicy = this.getUpdatePolicy();
            result = result * 59 + ($updatePolicy == null ? 43 : ((Object)((Object)$updatePolicy)).hashCode());
            LaunchListener $listener = this.getListener();
            result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
            Session $session = this.getSession();
            result = result * 59 + ($session == null ? 43 : $session.hashCode());
            return result;
        }

        public String toString() {
            return "LaunchOptions.Builder(window=" + this.getWindow() + ", instance=" + this.getInstance() + ", updatePolicy=" + (Object)((Object)this.getUpdatePolicy()) + ", listener=" + this.getListener() + ", session=" + this.getSession() + ")";
        }
    }
}

