/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.concurrency.SettableProgress;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.LoginService;
import com.skcraft.launcher.auth.OfflineSession;
import com.skcraft.launcher.auth.SavedSession;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.auth.UserType;
import com.skcraft.launcher.dialog.OfflineUsernameDialog;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class AccountSelectDialog
extends JDialog {
    private final JList<SavedSession> accountList;
    private final JButton loginButton = new JButton(SharedLocale.tr("accounts.play"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));
    private final JButton addOfflineButton = new JButton(SharedLocale.tr("accounts.addOffline"));
    private final JButton addMicrosoftButton = new JButton(SharedLocale.tr("accounts.addMicrosoft"));
    private final JButton removeSelected = new JButton(SharedLocale.tr("accounts.removeSelected"));
    private final JButton offlineButton = new JButton(SharedLocale.tr("login.playOffline"));
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);
    private final Launcher launcher;
    private Session selected;

    public AccountSelectDialog(Window owner, Launcher launcher) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        this.launcher = launcher;
        this.accountList = new JList<SavedSession>(launcher.getAccounts());
        this.setTitle(SharedLocale.tr("accounts.title"));
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 250));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.accountList.setSelectionMode(0);
        this.accountList.setLayoutOrientation(0);
        this.accountList.setVisibleRowCount(0);
        this.accountList.setCellRenderer(new AccountRenderer());
        JScrollPane accountPane = new JScrollPane(this.accountList);
        accountPane.setPreferredSize(new Dimension(280, 150));
        accountPane.setAlignmentX(0.5f);
        this.loginButton.setFont(this.loginButton.getFont().deriveFont(1));
        this.loginButton.setMargin(new Insets(0, 10, 0, 10));
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(26, 13, 13, 13));
        if (this.launcher.getConfig().isOfflineEnabled()) {
            this.buttonsPanel.addElement(this.offlineButton);
        }
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.cancelButton);
        this.buttonsPanel.addElement(this.loginButton);
        JPanel loginButtonsRow = new JPanel(new BorderLayout(0, 5));
        this.addOfflineButton.setAlignmentX(0.5f);
        this.addMicrosoftButton.setAlignmentX(0.5f);
        this.removeSelected.setAlignmentX(0.5f);
        loginButtonsRow.add((Component)this.addOfflineButton, "North");
        loginButtonsRow.add((Component)this.addMicrosoftButton, "Center");
        loginButtonsRow.add((Component)this.removeSelected, "South");
        loginButtonsRow.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JPanel listAndLoginContainer = new JPanel();
        listAndLoginContainer.add((Component)accountPane, "West");
        listAndLoginContainer.add((Component)loginButtonsRow, "East");
        listAndLoginContainer.add(Box.createVerticalStrut(5));
        listAndLoginContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)listAndLoginContainer, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.loginButton.addActionListener(ev -> this.attemptExistingLogin(this.accountList.getSelectedValue()));
        this.cancelButton.addActionListener(ev -> this.dispose());
        this.addOfflineButton.addActionListener(ev -> {
            String username = OfflineUsernameDialog.showUsernameDialog(this);
            if (username != null) {
                Session newSession = this.launcher.getOfflineLogin().login(username);
                this.launcher.getAccounts().update(newSession.toSavedSession());
                this.setResult(newSession);
            }
        });
        this.addMicrosoftButton.addActionListener(ev -> this.attemptMicrosoftLogin(SharedLocale.tr("login.microsoft.seeBrowser")));
        this.offlineButton.addActionListener(ev -> this.setResult(new OfflineSession(this.launcher.getProperties().getProperty("offlinePlayerName"))));
        this.removeSelected.addActionListener(ev -> {
            boolean confirmed;
            if (this.accountList.getSelectedValue() != null && (confirmed = SwingHelper.confirmDialog(this, SharedLocale.tr("accounts.confirmForget"), SharedLocale.tr("accounts.confirmForgetTitle")))) {
                this.launcher.getAccounts().remove(this.accountList.getSelectedValue());
            }
        });
        this.accountList.setSelectedIndex(0);
    }

    @Override
    public void dispose() {
        this.accountList.setModel(new DefaultListModel());
        super.dispose();
    }

    public static Session showAccountRequest(Window owner, Launcher launcher) {
        AccountSelectDialog dialog = new AccountSelectDialog(owner, launcher);
        dialog.setVisible(true);
        if (dialog.selected != null && dialog.selected.isOnline()) {
            launcher.getAccounts().update(dialog.selected.toSavedSession());
        }
        Persistence.commitAndForget(launcher.getAccounts());
        return dialog.selected;
    }

    private void setResult(Session result) {
        this.selected = result;
        this.dispose();
    }

    private void attemptMicrosoftLogin(String status) {
        SettableProgress progress = new SettableProgress(status, -1.0);
        ListenableFuture<Object> future = this.launcher.getExecutor().submit(() -> {
            Session newSession = this.launcher.getMicrosoftLogin().login(() -> progress.set(SharedLocale.tr("login.loggingInStatus"), -1.0));
            if (newSession != null) {
                this.launcher.getAccounts().update(newSession.toSavedSession());
                this.setResult(newSession);
            }
            return null;
        });
        ProgressDialog.showProgress(this, future, progress, SharedLocale.tr("login.loggingInTitle"), status);
        SwingHelper.addErrorDialogCallback(this, future);
    }

    private void attemptExistingLogin(final SavedSession session) {
        if (session == null) {
            return;
        }
        LoginService loginService = this.launcher.getLoginService(session.getType());
        RestoreSessionCallable callable = new RestoreSessionCallable(loginService, session);
        ObservableFuture<Session> future = new ObservableFuture<Session>(this.launcher.getExecutor().submit(callable), callable);
        Futures.addCallback(future, new FutureCallback<Session>(){

            @Override
            public void onSuccess(@Nullable Session result) {
                AccountSelectDialog.this.setResult(result);
            }

            @Override
            public void onFailure(@Nonnull Throwable t) {
                if (t instanceof AuthenticationException && ((AuthenticationException)t).isInvalidatedSession()) {
                    AccountSelectDialog.this.relogin(session, t.getLocalizedMessage());
                } else {
                    SwingHelper.showErrorDialog(AccountSelectDialog.this, t.getLocalizedMessage(), SharedLocale.tr("errorTitle"), t);
                }
            }
        }, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this, future, SharedLocale.tr("login.loggingInTitle"), SharedLocale.tr("login.loggingInStatus"));
    }

    private void relogin(SavedSession session, String message) {
        if (session.getType() == UserType.MICROSOFT) {
            this.attemptMicrosoftLogin(message);
        } else if (session.getType() == UserType.OFFLINE) {
            Session newSession = this.launcher.getOfflineLogin().login(session.getUsername());
            this.launcher.getAccounts().update(newSession.toSavedSession());
            this.setResult(newSession);
        } else {
            SwingHelper.showErrorDialog(this, "Unknown account type: " + (Object)((Object)session.getType()), "Error");
        }
    }

    private static class AccountRenderer
    extends JLabel
    implements ListCellRenderer<SavedSession> {
        public AccountRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SavedSession> list, SavedSession value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getUsername());
            if (value.getAvatarImage() != null) {
                this.setIcon(new ImageIcon(value.getAvatarImage()));
            } else {
                this.setIcon(SwingHelper.createIcon(Launcher.class, "default_skin.png", 32, 32));
            }
            if (isSelected) {
                this.setOpaque(true);
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setOpaque(false);
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class RestoreSessionCallable
    implements Callable<Session>,
    ProgressObservable {
        private final LoginService service;
        private final SavedSession session;

        @Override
        public Session call() throws Exception {
            return this.service.restore(this.session);
        }

        @Override
        public String getStatus() {
            return SharedLocale.tr("accounts.refreshingStatus");
        }

        @Override
        public double getProgress() {
            return -1.0;
        }

        public RestoreSessionCallable(LoginService service, SavedSession session) {
            this.service = service;
            this.session = session;
        }
    }
}

