/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch;

import com.google.common.base.Function;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.dialog.ProcessConsoleFrame;
import com.skcraft.launcher.swing.MessageLog;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class LaunchProcessHandler
implements Function<Process, ProcessConsoleFrame> {
    private static final Logger log = Logger.getLogger(LaunchProcessHandler.class.getName());
    private static final int CONSOLE_NUM_LINES = 10000;
    private final Launcher launcher;
    private ProcessConsoleFrame consoleFrame;

    public LaunchProcessHandler(@NonNull Launcher launcher) {
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.launcher = launcher;
    }

    @Override
    public ProcessConsoleFrame apply(final Process process) {
        log.info("Watching process " + process);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LaunchProcessHandler.this.consoleFrame = new ProcessConsoleFrame(10000, true);
                    LaunchProcessHandler.this.consoleFrame.setProcess(process);
                    LaunchProcessHandler.this.consoleFrame.setVisible(true);
                    MessageLog messageLog = LaunchProcessHandler.this.consoleFrame.getMessageLog();
                    messageLog.consume(process.getInputStream());
                    messageLog.consume(process.getErrorStream());
                }
            });
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            log.log(Level.WARNING, "Unexpected failure", e);
        }
        log.info("Process ended, re-showing launcher...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LaunchProcessHandler.this.consoleFrame != null) {
                    LaunchProcessHandler.this.consoleFrame.setProcess(null);
                    LaunchProcessHandler.this.consoleFrame.requestFocus();
                }
            }
        });
        return this.consoleFrame;
    }
}

