/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Configuration;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.auth.YggdrasilLoginService;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.ActionListeners;
import com.skcraft.launcher.swing.FormPanel;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.LinkButton;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import lombok.NonNull;

public class LoginDialog
extends JDialog {
    private final Launcher launcher;
    private Session session;
    private final JLabel message = new JLabel(SharedLocale.tr("login.defaultMessage"));
    private final JTextField usernameText = new JTextField();
    private final JPasswordField passwordText = new JPasswordField();
    private final JButton loginButton = new JButton(SharedLocale.tr("login.login"));
    private final LinkButton recoverButton = new LinkButton(SharedLocale.tr("login.recoverAccount"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));
    private final FormPanel formPanel = new FormPanel();
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);

    public LoginDialog(Window owner, @NonNull Launcher launcher, Optional<ReloginDetails> reloginDetails) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.launcher = launcher;
        this.setTitle(SharedLocale.tr("login.title"));
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(420, 0));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LoginDialog.this.dispose();
            }
        });
        reloginDetails.ifPresent(details -> this.message.setText(((ReloginDetails)details).message));
    }

    private void initComponents() {
        this.usernameText.setEditable(true);
        this.loginButton.setFont(this.loginButton.getFont().deriveFont(1));
        this.formPanel.addRow(this.message);
        this.formPanel.addRow(new JLabel(SharedLocale.tr("login.idEmail")), this.usernameText);
        this.formPanel.addRow(new JLabel(SharedLocale.tr("login.password")), this.passwordText);
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(26, 13, 13, 13));
        this.buttonsPanel.addElement(this.recoverButton);
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.loginButton);
        this.buttonsPanel.addElement(this.cancelButton);
        this.add((Component)this.formPanel, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.getRootPane().setDefaultButton(this.loginButton);
        this.passwordText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.recoverButton.addActionListener(ActionListeners.openURL(this.recoverButton, this.launcher.getProperties().getProperty("resetPasswordUrl")));
        this.loginButton.addActionListener(e -> this.prepareLogin());
        this.cancelButton.addActionListener(e -> this.dispose());
    }

    private void prepareLogin() {
        if (!this.usernameText.getText().isEmpty()) {
            String password = this.passwordText.getText();
            if (password == null || password.isEmpty()) {
                SwingHelper.showErrorDialog(this, SharedLocale.tr("login.noPasswordError"), SharedLocale.tr("login.noPasswordTitle"));
            } else {
                this.attemptLogin(this.usernameText.getText(), password);
            }
        } else {
            SwingHelper.showErrorDialog(this, SharedLocale.tr("login.noLoginError"), SharedLocale.tr("login.noLoginTitle"));
        }
    }

    private void attemptLogin(String username, String password) {
        LoginCallable callable = new LoginCallable(username, password);
        ObservableFuture<Session> future = new ObservableFuture<Session>(this.launcher.getExecutor().submit(callable), callable);
        Futures.addCallback(future, new FutureCallback<Session>(){

            @Override
            public void onSuccess(Session result) {
                LoginDialog.this.setResult(result);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        }, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this, future, SharedLocale.tr("login.loggingInTitle"), SharedLocale.tr("login.loggingInStatus"));
        SwingHelper.addErrorDialogCallback(this, future);
    }

    private void setResult(Session session) {
        this.session = session;
        this.dispose();
    }

    public static Session showLoginRequest(Window owner, Launcher launcher) {
        return LoginDialog.showLoginRequest(owner, launcher, null);
    }

    public static Session showLoginRequest(Window owner, Launcher launcher, ReloginDetails reloginDetails) {
        LoginDialog dialog = new LoginDialog(owner, launcher, Optional.ofNullable(reloginDetails));
        dialog.setVisible(true);
        return dialog.getSession();
    }

    public Session getSession() {
        return this.session;
    }

    public static class ReloginDetails {
        private final String username;
        private final String message;

        public ReloginDetails(String username, String message) {
            this.username = username;
            this.message = message;
        }

        public String getUsername() {
            return this.username;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReloginDetails)) {
                return false;
            }
            ReloginDetails other = (ReloginDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReloginDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "LoginDialog.ReloginDetails(username=" + this.getUsername() + ", message=" + this.getMessage() + ")";
        }
    }

    private class LoginCallable
    implements Callable<Session>,
    ProgressObservable {
        private final String username;
        private final String password;

        @Override
        public Session call() throws AuthenticationException, IOException, InterruptedException {
            YggdrasilLoginService service = LoginDialog.this.launcher.getYggdrasil();
            Session identity = service.login(this.username, this.password);
            if (identity != null) {
                Configuration config = LoginDialog.this.launcher.getConfig();
                if (!config.isOfflineEnabled()) {
                    config.setOfflineEnabled(true);
                    Persistence.commitAndForget(config);
                }
                return identity;
            }
            throw new AuthenticationException("Minecraft not owned", SharedLocale.tr("login.minecraftNotOwnedError"));
        }

        @Override
        public double getProgress() {
            return -1.0;
        }

        @Override
        public String getStatus() {
            return SharedLocale.tr("login.loggingInStatus");
        }

        public LoginCallable(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

