/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.selfupdate;

import com.skcraft.concurrency.DefaultProgress;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.install.FileMover;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;

public class SelfUpdater
implements Callable<File>,
ProgressObservable {
    private final Launcher launcher;
    private final URL url;
    private final Installer installer;
    private ProgressObservable progress = new DefaultProgress(0.0, SharedLocale.tr("updater.updating"));

    public SelfUpdater(@NonNull Launcher launcher, @NonNull URL url) {
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.launcher = launcher;
        this.url = url;
        this.installer = new Installer(launcher.getInstallerDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File call() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            File dir = this.launcher.getLauncherBinariesDir();
            File file = new File(dir, System.currentTimeMillis() + ".jar");
            File tempFile = this.installer.getDownloader().download(this.url, "", 10000L, "launcher.jar");
            this.progress = this.installer.getDownloader();
            this.installer.download();
            this.installer.queue(new FileMover(tempFile, file));
            this.progress = this.installer;
            this.installer.execute(this.launcher);
            File file2 = file;
            return file2;
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    public double getProgress() {
        return this.progress.getProgress();
    }

    @Override
    public String getStatus() {
        return this.progress.getStatus();
    }
}

