/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.modpack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.install.InstallExtras;
import com.skcraft.launcher.install.InstallLog;
import com.skcraft.launcher.install.InstallLogFileMover;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.install.UpdateCache;
import com.skcraft.launcher.model.modpack.ManifestEntry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

public class FileInstall
extends ManifestEntry {
    private static HashFunction hf = Hashing.sha1();
    private String version;
    private String hash;
    private String location;
    private String to;
    private long size;
    private boolean userFile;

    @JsonIgnore
    public String getImpliedVersion() {
        return Preconditions.checkNotNull(this.version != null ? this.version : this.hash);
    }

    @JsonIgnore
    public String getTargetPath() {
        return Preconditions.checkNotNull(this.to != null ? this.to : this.location);
    }

    @Override
    public void install(@NonNull Installer installer, @NonNull InstallLog log, @NonNull UpdateCache cache, InstallExtras extras) throws IOException {
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        if (this.getWhen() != null && !this.getWhen().matches()) {
            return;
        }
        String targetPath = this.getTargetPath();
        File targetFile = new File(extras.getContentDir(), targetPath);
        String fileVersion = this.getImpliedVersion();
        URL url = LauncherUtils.concat(this.getManifest().getObjectsUrl(), this.getLocation());
        if (this.shouldUpdate(cache, targetFile)) {
            long size = this.size;
            if (size <= 0L) {
                size = 10240L;
            }
            File tempFile = installer.getDownloader().download(url, fileVersion, size, this.to);
            installer.queue(new InstallLogFileMover(log, tempFile, targetFile));
        } else {
            log.add(this.to, this.to);
        }
    }

    private boolean shouldUpdate(UpdateCache cache, File targetFile) throws IOException {
        String existingHash;
        if (targetFile.exists() && this.isUserFile()) {
            return false;
        }
        if (!targetFile.exists()) {
            return true;
        }
        if (this.hash != null && (existingHash = Files.hash(targetFile, hf).toString()).equalsIgnoreCase(this.hash)) {
            return false;
        }
        return cache.mark(FilenameUtils.normalize(this.getTargetPath()), this.getImpliedVersion());
    }

    public String getVersion() {
        return this.version;
    }

    public String getHash() {
        return this.hash;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTo() {
        return this.to;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isUserFile() {
        return this.userFile;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setUserFile(boolean userFile) {
        this.userFile = userFile;
    }

    @Override
    public String toString() {
        return "FileInstall(version=" + this.getVersion() + ", hash=" + this.getHash() + ", location=" + this.getLocation() + ", to=" + this.getTo() + ", size=" + this.getSize() + ", userFile=" + this.isUserFile() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInstall)) {
            return false;
        }
        FileInstall other = (FileInstall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isUserFile() != other.isUserFile()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileInstall;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        result = result * 59 + (this.isUserFile() ? 79 : 97);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }
}

