/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Splitter;
import com.skcraft.launcher.model.loader.SidedData;
import com.skcraft.launcher.model.minecraft.GameArgument;
import com.skcraft.launcher.model.minecraft.JavaVersion;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.MinecraftArguments;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionManifest {
    private String id;
    private Date time;
    private Date releaseTime;
    private String assets;
    private AssetIndex assetIndex;
    private String type;
    private MinecraftArguments arguments;
    private String mainClass;
    private int minimumLauncherVersion;
    private LinkedHashSet<Library> libraries;
    private JavaVersion javaVersion;
    private SidedData<LoggingConfig> logging;
    private Map<String, Artifact> downloads = new HashMap<String, Artifact>();

    public String getAssetId() {
        return this.getAssetIndex() != null ? this.getAssetIndex().getId() : "legacy";
    }

    @JsonIgnore
    public String getNewMinecraftArguments() {
        return this.getArguments() != null ? this.getNewArguments() : "";
    }

    @JsonIgnore
    private String getNewArguments() {
        String result = "";
        if (this.getArguments() != null) {
            for (GameArgument obj : this.getArguments().getGameArguments()) {
                result = result + obj.getJoinedValue() + " ";
            }
        }
        return result.trim();
    }

    public void setMinecraftArguments(String minecraftArguments) {
        MinecraftArguments result = new MinecraftArguments();
        for (String arg : Splitter.on(' ').split(minecraftArguments)) {
            result.getGameArguments().add(new GameArgument(arg));
        }
        this.setArguments(result);
    }

    public String getId() {
        return this.id;
    }

    public Date getTime() {
        return this.time;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public String getAssets() {
        return this.assets;
    }

    public AssetIndex getAssetIndex() {
        return this.assetIndex;
    }

    public String getType() {
        return this.type;
    }

    public MinecraftArguments getArguments() {
        return this.arguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public LinkedHashSet<Library> getLibraries() {
        return this.libraries;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public SidedData<LoggingConfig> getLogging() {
        return this.logging;
    }

    public Map<String, Artifact> getDownloads() {
        return this.downloads;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public void setAssets(String assets) {
        this.assets = assets;
    }

    public void setAssetIndex(AssetIndex assetIndex) {
        this.assetIndex = assetIndex;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArguments(MinecraftArguments arguments) {
        this.arguments = arguments;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setMinimumLauncherVersion(int minimumLauncherVersion) {
        this.minimumLauncherVersion = minimumLauncherVersion;
    }

    public void setLibraries(LinkedHashSet<Library> libraries) {
        this.libraries = libraries;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setLogging(SidedData<LoggingConfig> logging) {
        this.logging = logging;
    }

    public void setDownloads(Map<String, Artifact> downloads) {
        this.downloads = downloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionManifest)) {
            return false;
        }
        VersionManifest other = (VersionManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinimumLauncherVersion() != other.getMinimumLauncherVersion()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$time = this.getTime();
        Date other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Date this$releaseTime = this.getReleaseTime();
        Date other$releaseTime = other.getReleaseTime();
        if (this$releaseTime == null ? other$releaseTime != null : !((Object)this$releaseTime).equals(other$releaseTime)) {
            return false;
        }
        String this$assets = this.getAssets();
        String other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) {
            return false;
        }
        AssetIndex this$assetIndex = this.getAssetIndex();
        AssetIndex other$assetIndex = other.getAssetIndex();
        if (this$assetIndex == null ? other$assetIndex != null : !((Object)this$assetIndex).equals(other$assetIndex)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        MinecraftArguments this$arguments = this.getArguments();
        MinecraftArguments other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        LinkedHashSet<Library> this$libraries = this.getLibraries();
        LinkedHashSet<Library> other$libraries = other.getLibraries();
        if (this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries)) {
            return false;
        }
        JavaVersion this$javaVersion = this.getJavaVersion();
        JavaVersion other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !((Object)this$javaVersion).equals(other$javaVersion)) {
            return false;
        }
        SidedData<LoggingConfig> this$logging = this.getLogging();
        SidedData<LoggingConfig> other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        Map<String, Artifact> this$downloads = this.getDownloads();
        Map<String, Artifact> other$downloads = other.getDownloads();
        return !(this$downloads == null ? other$downloads != null : !((Object)this$downloads).equals(other$downloads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionManifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinimumLauncherVersion();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Date $releaseTime = this.getReleaseTime();
        result = result * 59 + ($releaseTime == null ? 43 : ((Object)$releaseTime).hashCode());
        String $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : $assets.hashCode());
        AssetIndex $assetIndex = this.getAssetIndex();
        result = result * 59 + ($assetIndex == null ? 43 : ((Object)$assetIndex).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        MinecraftArguments $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        LinkedHashSet<Library> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        JavaVersion $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : ((Object)$javaVersion).hashCode());
        SidedData<LoggingConfig> $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        Map<String, Artifact> $downloads = this.getDownloads();
        result = result * 59 + ($downloads == null ? 43 : ((Object)$downloads).hashCode());
        return result;
    }

    public String toString() {
        return "VersionManifest(id=" + this.getId() + ", time=" + this.getTime() + ", releaseTime=" + this.getReleaseTime() + ", assets=" + this.getAssets() + ", assetIndex=" + this.getAssetIndex() + ", type=" + this.getType() + ", arguments=" + this.getArguments() + ", mainClass=" + this.getMainClass() + ", minimumLauncherVersion=" + this.getMinimumLauncherVersion() + ", libraries=" + this.getLibraries() + ", javaVersion=" + this.getJavaVersion() + ", logging=" + this.getLogging() + ", downloads=" + this.getDownloads() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoggingConfig {
        private String argument;
        private Artifact file;

        public String getArgument() {
            return this.argument;
        }

        public Artifact getFile() {
            return this.file;
        }

        public void setArgument(String argument) {
            this.argument = argument;
        }

        public void setFile(Artifact file) {
            this.file = file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoggingConfig)) {
                return false;
            }
            LoggingConfig other = (LoggingConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$argument = this.getArgument();
            String other$argument = other.getArgument();
            if (this$argument == null ? other$argument != null : !this$argument.equals(other$argument)) {
                return false;
            }
            Artifact this$file = this.getFile();
            Artifact other$file = other.getFile();
            return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LoggingConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $argument = this.getArgument();
            result = result * 59 + ($argument == null ? 43 : $argument.hashCode());
            Artifact $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            return result;
        }

        public String toString() {
            return "VersionManifest.LoggingConfig(argument=" + this.getArgument() + ", file=" + this.getFile() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AssetIndex {
        private String id;
        private String url;

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetIndex)) {
                return false;
            }
            AssetIndex other = (AssetIndex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssetIndex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "VersionManifest.AssetIndex(id=" + this.getId() + ", url=" + this.getUrl() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Artifact {
        private String id;
        private String url;
        private int size;
        @JsonProperty(value="sha1")
        private String hash;

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public int getSize() {
            return this.size;
        }

        public String getHash() {
            return this.hash;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setSize(int size) {
            this.size = size;
        }

        @JsonProperty(value="sha1")
        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Artifact)) {
                return false;
            }
            Artifact other = (Artifact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Artifact;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        public String toString() {
            return "VersionManifest.Artifact(id=" + this.getId() + ", url=" + this.getUrl() + ", size=" + this.getSize() + ", hash=" + this.getHash() + ")";
        }
    }
}

