/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth;

import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.auth.UserType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;

public class OfflineSession
implements Session {
    private static Map<String, String> dummyProperties = Collections.emptyMap();
    private final String name;

    public OfflineSession(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    public String getUuid() {
        return this.generateUuidFromUsername(this.name).toString();
    }

    private UUID generateUuidFromUsername(String username) {
        try {
            int i;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(username.getBytes(StandardCharsets.UTF_8));
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i < 8; ++i) {
                msb = msb << 8 | (long)(hash[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                lsb = lsb << 8 | (long)(hash[i] & 0xFF);
            }
            return new UUID(msb, lsb);
        }
        catch (NoSuchAlgorithmException e) {
            return new UUID(0L, username.hashCode());
        }
    }

    @Override
    public String getAccessToken() {
        return this.generateUuidFromUsername(this.name + "_access").toString();
    }

    @Override
    public Map<String, String> getUserProperties() {
        return dummyProperties;
    }

    @Override
    public String getSessionToken() {
        return String.format("token:%s:%s", this.getAccessToken(), this.getUuid());
    }

    @Override
    public UserType getUserType() {
        return UserType.OFFLINE;
    }

    @Override
    public byte[] getAvatarImage() {
        return null;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

