/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.loader;

import com.google.common.base.Function;
import com.skcraft.launcher.model.loader.LoaderManifest;
import com.skcraft.launcher.model.loader.SidedData;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.MavenName;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.modpack.DownloadableFile;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.util.Environment;
import java.io.File;
import java.util.HashMap;

public class LoaderSubResolver
implements Function<String, String> {
    private final Manifest manifest;
    private final LoaderManifest loader;
    private final Environment env;
    private final Side side;
    private final File libraryDir;
    private final HashMap<String, DownloadableFile.LocalFile> localFiles;

    public String getPathOf(String ... rest) {
        File file = this.libraryDir;
        for (String part : rest) {
            file = new File(file, part);
        }
        return file.getAbsolutePath();
    }

    @Override
    public String apply(String arg) {
        if (arg == null) {
            return null;
        }
        arg = this.replaceTokens(arg);
        while (true) {
            char start = arg.charAt(0);
            int bound = arg.length() - 1;
            char end = arg.charAt(bound);
            if (start == '{' && end == '}') {
                SidedData<String> sidedData = this.loader.getSidedData().get(arg.substring(1, bound));
                if (sidedData == null) continue;
                arg = sidedData.resolveFor(this.side);
                continue;
            }
            if (start == '[' && end == ']') {
                String libraryName = arg.substring(1, bound);
                Library library = this.loader.findLibrary(libraryName);
                if (library != null) {
                    arg = this.getPathOf(library.getPath(this.env));
                    continue;
                }
                arg = this.getPathOf(MavenName.from(libraryName).getFilePath());
                continue;
            }
            if (start == '&' && end == '&') {
                String localFileName = arg.substring(1, bound);
                if (this.localFiles.containsKey(localFileName)) {
                    arg = this.localFiles.get(localFileName).getLocation().getAbsolutePath();
                    continue;
                }
                arg = localFileName;
                continue;
            }
            if (start != '\'' || end != '\'') break;
            arg = arg.substring(1, bound);
        }
        return arg;
    }

    private String replaceTokens(String arg) {
        StringBuilder buf = new StringBuilder();
        int length = arg.length();
        block0: for (int i = 0; i < length; ++i) {
            char c = arg.charAt(i);
            if (c == '\\') {
                buf.append(arg.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder keyBuf = new StringBuilder();
                for (int j = i + 1; j <= length; ++j) {
                    if (j == length) {
                        throw new IllegalArgumentException("Illegal pattern: unclosed " + c);
                    }
                    char d = arg.charAt(j);
                    if (d == '\\') {
                        keyBuf.append(arg.charAt(j + 1));
                        ++j;
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        String key = keyBuf.toString();
                        SidedData<String> sidedData = this.loader.getSidedData().get(key);
                        if (sidedData == null) {
                            throw new IllegalArgumentException("Missing key: " + key);
                        }
                        buf.append(sidedData.resolveFor(this.side));
                        i = j;
                        continue block0;
                    }
                    if (c == '\'' && d == '\'') {
                        buf.append(keyBuf.toString());
                        i = j;
                        continue block0;
                    }
                    keyBuf.append(d);
                }
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public LoaderSubResolver(Manifest manifest, LoaderManifest loader, Environment env, Side side, File libraryDir, HashMap<String, DownloadableFile.LocalFile> localFiles) {
        this.manifest = manifest;
        this.loader = loader;
        this.env = env;
        this.side = side;
        this.libraryDir = libraryDir;
        this.localFiles = localFiles;
    }
}

