/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.launcher.Instance;
import com.skcraft.launcher.InstanceSettings;
import com.skcraft.launcher.dialog.component.BetterComboBox;
import com.skcraft.launcher.launch.MemorySettings;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.JavaRuntimeFinder;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.FormPanel;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class InstanceSettingsDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(InstanceSettingsDialog.class.getName());
    private final InstanceSettings settings;
    private final LinedBoxPanel formsPanel = new LinedBoxPanel(false);
    private final FormPanel memorySettingsPanel = new FormPanel();
    private final JCheckBox enableMemorySettings = new JCheckBox(SharedLocale.tr("instance.options.customMemory"));
    private final JSpinner minMemorySpinner = new JSpinner();
    private final JSpinner maxMemorySpinner = new JSpinner();
    private final JCheckBox enableCustomRuntime = new JCheckBox(SharedLocale.tr("instance.options.customJava"));
    private final FormPanel runtimePanel = new FormPanel();
    private final JComboBox<JavaRuntime> javaRuntimeBox = new BetterComboBox<JavaRuntime>();
    private final JTextField javaArgsBox = new JTextField();
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);
    private final JButton okButton = new JButton(SharedLocale.tr("button.save"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));
    private boolean saved = false;

    public InstanceSettingsDialog(Window owner, InstanceSettings settings) {
        super(owner);
        this.settings = settings;
        this.setTitle(SharedLocale.tr("instance.options.title"));
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.initComponents();
        this.setSize(new Dimension(400, 500));
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.memorySettingsPanel.addRow(this.enableMemorySettings);
        this.memorySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.minMemory")), this.minMemorySpinner);
        this.memorySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.maxMemory")), this.maxMemorySpinner);
        JavaRuntime[] javaRuntimes = JavaRuntimeFinder.getAvailableRuntimes().toArray(new JavaRuntime[0]);
        this.javaRuntimeBox.setModel(new DefaultComboBoxModel<JavaRuntime>(javaRuntimes));
        this.runtimePanel.addRow(this.enableCustomRuntime);
        this.runtimePanel.addRow(new JLabel(SharedLocale.tr("options.jvmRuntime")), this.javaRuntimeBox);
        this.runtimePanel.addRow(new JLabel(SharedLocale.tr("options.jvmArguments")), this.javaArgsBox);
        this.okButton.setMargin(new Insets(0, 10, 0, 10));
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.okButton);
        this.buttonsPanel.addElement(this.cancelButton);
        this.enableMemorySettings.addActionListener(e -> {
            if (this.enableMemorySettings.isSelected()) {
                this.settings.setMemorySettings(new MemorySettings());
            } else {
                this.settings.setMemorySettings(null);
            }
            this.updateComponents();
        });
        this.enableCustomRuntime.addActionListener(e -> this.runtimePanel.setEnabled(this.enableCustomRuntime.isSelected()));
        this.okButton.addActionListener(e -> {
            this.save();
            this.dispose();
        });
        this.cancelButton.addActionListener(e -> this.dispose());
        this.formsPanel.addElement(this.memorySettingsPanel);
        this.formsPanel.addElement(this.runtimePanel);
        this.add((Component)this.formsPanel, "North");
        this.add((Component)this.buttonsPanel, "South");
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.settings.getMemorySettings() != null) {
            this.memorySettingsPanel.setEnabled(true);
            this.enableMemorySettings.setSelected(true);
            this.minMemorySpinner.setValue(this.settings.getMemorySettings().getMinMemory());
            this.maxMemorySpinner.setValue(this.settings.getMemorySettings().getMaxMemory());
        } else {
            this.memorySettingsPanel.setEnabled(false);
            this.enableMemorySettings.setSelected(false);
        }
        if (this.settings.getRuntime() != null) {
            this.runtimePanel.setEnabled(true);
            this.enableCustomRuntime.setSelected(true);
        } else {
            this.runtimePanel.setEnabled(false);
            this.enableCustomRuntime.setSelected(false);
        }
        this.javaRuntimeBox.setSelectedItem(this.settings.getRuntime());
        this.javaArgsBox.setText(this.settings.getCustomJvmArgs());
    }

    private void save() {
        if (this.enableMemorySettings.isSelected()) {
            MemorySettings memorySettings = this.settings.getMemorySettings();
            memorySettings.setMinMemory((Integer)this.minMemorySpinner.getValue());
            memorySettings.setMaxMemory((Integer)this.maxMemorySpinner.getValue());
        } else {
            this.settings.setMemorySettings(null);
        }
        if (this.enableCustomRuntime.isSelected()) {
            this.settings.setRuntime((JavaRuntime)this.javaRuntimeBox.getSelectedItem());
            this.settings.setCustomJvmArgs(this.javaArgsBox.getText());
        } else {
            this.settings.setRuntime(null);
            this.settings.setCustomJvmArgs(null);
        }
        this.saved = true;
    }

    public static boolean open(Window parent, Instance instance) {
        InstanceSettingsDialog dialog = new InstanceSettingsDialog(parent, instance.getSettings());
        dialog.setVisible(true);
        if (dialog.saved) {
            Persistence.commitAndForget(instance);
        }
        return dialog.saved;
    }
}

