/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth.microsoft;

import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.microsoft.model.XblAuthProperties;
import com.skcraft.launcher.auth.microsoft.model.XboxAuthRequest;
import com.skcraft.launcher.auth.microsoft.model.XboxAuthResponse;
import com.skcraft.launcher.auth.microsoft.model.XboxAuthorization;
import com.skcraft.launcher.auth.microsoft.model.XstsAuthProperties;
import com.skcraft.launcher.auth.microsoft.model.XstsError;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import java.io.IOException;
import java.net.URL;

public class XboxTokenAuthorizer {
    private static final URL XBL_AUTHENTICATE_URL = HttpRequest.url("https://user.auth.xboxlive.com/user/authenticate");
    private static final URL XSTS_AUTHENTICATE_URL = HttpRequest.url("https://xsts.auth.xboxlive.com/xsts/authorize");

    public static XboxAuthorization authorizeWithXbox(String accessToken) throws IOException, InterruptedException, AuthenticationException {
        XboxAuthRequest<XblAuthProperties> xblPayload = new XboxAuthRequest<XblAuthProperties>(new XblAuthProperties("d=" + accessToken));
        XboxAuthResponse xblResponse = HttpRequest.post(XBL_AUTHENTICATE_URL).bodyJson(xblPayload).header("Accept", "application/json").execute().expectResponseCodeOr(200, req -> new AuthenticationException("Error authenticating with Xbox Live", SharedLocale.tr("login.xbox.generic"))).returnContent().asJson(XboxAuthResponse.class);
        XboxAuthRequest<XstsAuthProperties> xstsPayload = new XboxAuthRequest<XstsAuthProperties>(new XstsAuthProperties(xblResponse.getToken()));
        xstsPayload.setRelyingParty("rp://api.minecraftservices.com/");
        XboxAuthResponse xstsResponse = HttpRequest.post(XSTS_AUTHENTICATE_URL).bodyJson(xstsPayload).header("Accept", "application/json").execute().expectResponseCodeOr(200, req -> {
            XstsError xstsError = req.returnContent().asJson(XstsError.class);
            return new AuthenticationException(xstsError.getMessage(), XboxTokenAuthorizer.getErrorMessage(xstsError));
        }).returnContent().asJson(XboxAuthResponse.class);
        return new XboxAuthorization(xstsResponse.getToken(), xstsResponse.getUhs());
    }

    private static String getErrorMessage(XstsError xstsError) {
        long xboxErrorCode = xstsError.getXErr();
        if (xboxErrorCode == 2148916233L) {
            return SharedLocale.tr("login.xbox.noXboxAccount");
        }
        if (xboxErrorCode == 2148916238L) {
            return SharedLocale.tr("login.xbox.isChild");
        }
        if (!xstsError.getMessage().isEmpty()) {
            return SharedLocale.tr("login.xbox.errorMessage", xstsError.getMessage());
        }
        return SharedLocale.tr("login.xbox.unknown", xboxErrorCode);
    }
}

