/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final int BORDER_ROUNDNESS = 12;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    public static DecorationAreaType getRootPaneType(JRootPane rootPane) {
        DecorationAreaType type = SubstanceLookAndFeel.getDecorationType(rootPane);
        if (type == null || type == DecorationAreaType.NONE) {
            type = SubstanceCoreUtilities.isPaintRootPaneActivated(rootPane) ? (SubstanceCoreUtilities.isSecondaryWindow(rootPane) ? DecorationAreaType.SECONDARY_TITLE_PANE : DecorationAreaType.PRIMARY_TITLE_PANE) : (SubstanceCoreUtilities.isSecondaryWindow(rootPane) ? DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE : DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE);
        } else if (type == DecorationAreaType.PRIMARY_TITLE_PANE) {
            if (!SubstanceCoreUtilities.isPaintRootPaneActivated(rootPane)) {
                type = DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE;
            }
        } else if (type == DecorationAreaType.SECONDARY_TITLE_PANE && !SubstanceCoreUtilities.isPaintRootPaneActivated(rootPane)) {
            type = DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE;
        }
        return type;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (SubstanceCoreUtilities.isRoundedCorners(c)) {
            this.paintRoundedBorder(c, g, x, y, w, h);
        } else {
            this.paintSquareBorder(c, g, x, y, w, h);
        }
    }

    public void paintSquareBorder(Component c, Graphics g, int x, int y, int w, int h) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        if (skin == null) {
            return;
        }
        SubstanceColorScheme scheme = skin.getBackgroundColorScheme(SubstancePaneBorder.getRootPaneType(SwingUtilities.getRootPane(c)));
        JComponent titlePaneComp = SubstanceLookAndFeel.getTitlePaneComponent(SwingUtilities.windowForComponent(c));
        SubstanceColorScheme borderScheme = skin.getColorScheme(titlePaneComp, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(borderScheme.getUltraDarkColor());
        graphics.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        graphics.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        graphics.setColor(borderScheme.getDarkColor());
        graphics.drawLine(x, y, x + w - 2, y);
        graphics.drawLine(x, y, x, y + h - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        graphics.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        graphics.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        graphics.setColor(scheme.getLightColor());
        graphics.drawRect(x + 2, y + 2, w - 5, h - 5);
        graphics.drawRect(x + 3, y + 3, w - 7, h - 7);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        newInsets.top = SubstancePaneBorder.INSETS.top;
        newInsets.left = SubstancePaneBorder.INSETS.left;
        newInsets.bottom = SubstancePaneBorder.INSETS.bottom;
        newInsets.right = SubstancePaneBorder.INSETS.right;
        return newInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void paintRoundedBorder(Component c, Graphics g, int x, int y, int w, int h) {
        SubstanceColorScheme scheme = this.getColorScheme(c);
        if (scheme == null) {
            return;
        }
        SubstanceColorScheme borderScheme = this.getBorderColorScheme(c);
        Graphics2D graphics = (Graphics2D)g;
        int xl = x + 4 + 2;
        int xr = x + w - 4 - 3;
        int yt = y + 4 + 2;
        int yb = y + h - 4 - 3;
        Object rh = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(borderScheme.getUltraDarkColor());
        graphics.drawLine(xl, y + h - 1, xr, y + h - 1);
        graphics.drawLine(x + w - 1, yt, x + w - 1, yb);
        graphics.fillOval(x + w - 12, y + h - 12, 12, 12);
        graphics.setColor(borderScheme.getDarkColor());
        graphics.drawLine(xl, y, xr, y);
        graphics.drawLine(x, yt, x, yb);
        graphics.fillOval(0, 0, 12, 12);
        graphics.fillOval(0, y + h - 12, 12, 12);
        graphics.fillOval(x + w - 12, 0, 12, 12);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(xl, y + h - 2, xr, y + h - 2);
        graphics.drawLine(x + w - 2, yt, x + w - 2, yb);
        graphics.drawLine(xl, y + 1, xr, y + 1);
        graphics.drawLine(x + 1, yt, x + 1, yb);
        graphics.fillOval(1, 1, 12, 12);
        graphics.fillOval(1, y + h - 12 - 1, 12, 12);
        graphics.fillOval(x + w - 12 - 1, 1, 12, 12);
        graphics.fillOval(x + w - 12 - 1, y + h - 12 - 1, 12, 12);
        graphics.setColor(scheme.getLightColor());
        graphics.drawLine(xl, y + 2, xr, y + 2);
        graphics.drawLine(x + 2, yt, x + 2, yb);
        graphics.drawLine(xl, y + h - 3, xr, y + h - 3);
        graphics.drawLine(x + w - 3, yt, x + w - 3, yb);
        graphics.drawLine(xl, y + 3, xr, y + 3);
        graphics.drawLine(x + 3, yt, x + 3, yb);
        graphics.drawLine(xl, y + h - 4, xr, y + h - 4);
        graphics.drawLine(x + w - 4, yt, x + w - 4, yb);
        graphics.fillOval(2, 2, 12, 12);
        graphics.fillOval(2, y + h - 12 - 2, 12, 12);
        graphics.fillOval(x + w - 12 - 2, 2, 12, 12);
        graphics.fillOval(x + w - 12 - 2, y + h - 12 - 2, 12, 12);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rh);
    }

    private SubstanceColorScheme getColorScheme(Component c) {
        JRootPane rp = c instanceof JRootPane ? (JRootPane)c : SwingUtilities.getRootPane(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        if (skin == null) {
            return null;
        }
        DecorationAreaType type = SubstancePaneBorder.getRootPaneType(rp);
        return skin.getBackgroundColorScheme(type);
    }

    private SubstanceColorScheme getBorderColorScheme(Component c) {
        JRootPane rp = c instanceof JRootPane ? (JRootPane)c : SwingUtilities.getRootPane(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        if (skin == null) {
            return null;
        }
        JComponent titlePaneComp = SubstanceLookAndFeel.getTitlePaneComponent(SwingUtilities.windowForComponent(c));
        return skin.getColorScheme(SubstancePaneBorder.getRootPaneType(rp), ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
    }
}

