/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.dialog.AccountSelectDialog;
import com.skcraft.launcher.dialog.ProcessConsoleFrame;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.launch.LaunchListener;
import com.skcraft.launcher.launch.LaunchOptions;
import com.skcraft.launcher.launch.LaunchProcessHandler;
import com.skcraft.launcher.launch.Runner;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.model.minecraft.JavaVersion;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.update.Updater;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

public class LaunchSupervisor {
    private static final Logger log = Logger.getLogger(LaunchSupervisor.class.getName());
    private final Launcher launcher;

    public LaunchSupervisor(Launcher launcher) {
        this.launcher = launcher;
    }

    public void launch(LaunchOptions options) {
        final Window window = options.getWindow();
        final Instance instance = options.getInstance();
        final LaunchListener listener = options.getListener();
        try {
            Session session;
            boolean update = options.getUpdatePolicy().isUpdateEnabled() && instance.isUpdatePending();
            Date now = new Date();
            instance.setLastAccessed(now);
            Persistence.commitAndForget(instance);
            if (options.getSession() != null) {
                session = options.getSession();
            } else {
                session = AccountSelectDialog.showAccountRequest(window, this.launcher);
                if (session == null) {
                    return;
                }
            }
            if (!instance.isInstalled()) {
                update = true;
            }
            if (update) {
                Updater updater = new Updater(this.launcher, instance);
                updater.setOnline(options.getUpdatePolicy() == LaunchOptions.UpdatePolicy.ALWAYS_UPDATE || session.isOnline());
                ObservableFuture<Instance> future = new ObservableFuture<Instance>(this.launcher.getExecutor().submit(updater), updater);
                ProgressDialog.showProgress(window, future, SharedLocale.tr("launcher.updatingTitle"), SharedLocale.tr("launcher.updatingStatus", instance.getTitle()));
                SwingHelper.addErrorDialogCallback(window, future);
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.instancesUpdated();
                            }
                        });
                    }
                }, SwingExecutor.INSTANCE);
                Futures.addCallback(future, new FutureCallback<Instance>(){

                    @Override
                    public void onSuccess(Instance result) {
                        LaunchSupervisor.this.launch(window, instance, session, listener);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                }, SwingExecutor.INSTANCE);
            } else {
                this.launch(window, instance, session, listener);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SwingHelper.showErrorDialog(window, SharedLocale.tr("launcher.noInstanceError"), SharedLocale.tr("launcher.noInstanceTitle"));
        }
    }

    private void launch(Window window, Instance instance, Session session, final LaunchListener listener) {
        File extractDir = this.launcher.createExtractDir();
        Runner task = new Runner(this.launcher, instance, session, extractDir, new RuntimeVerifier(instance));
        ObservableFuture<Process> processFuture = new ObservableFuture<Process>(this.launcher.getExecutor().submit(task), task);
        ProgressDialog.showProgress(window, processFuture, SharedLocale.tr("launcher.launchingTItle"), SharedLocale.tr("launcher.launchingStatus", instance.getTitle()));
        Futures.addCallback(processFuture, new FutureCallback<Process>(){

            @Override
            public void onSuccess(Process result) {
                SwingUtilities.invokeLater(listener::gameStarted);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        ListenableFuture<ProcessConsoleFrame> future = Futures.transform(processFuture, new LaunchProcessHandler(this.launcher), (Executor)this.launcher.getExecutor());
        SwingHelper.addErrorDialogCallback(null, future);
        future.addListener(() -> {
            try {
                log.info("Process ended; cleaning up " + extractDir.getAbsolutePath());
                FileUtils.deleteDirectory(extractDir);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to clean up " + extractDir.getAbsolutePath(), e);
            }
        }, MoreExecutors.sameThreadExecutor());
        Futures.addCallback(future, new FutureCallback<ProcessConsoleFrame>(){

            @Override
            public void onSuccess(@Nullable ProcessConsoleFrame result) {
                listener.gameClosed();
            }

            @Override
            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    log.info("Process failure: " + t.getLocalizedMessage());
                }
            }
        }, SwingExecutor.INSTANCE);
    }

    static class RuntimeVerifier
    implements BiPredicate<JavaRuntime, JavaVersion> {
        private final Instance instance;

        @Override
        public boolean test(JavaRuntime javaRuntime, JavaVersion javaVersion) {
            Future fut = SwingExecutor.INSTANCE.submit(() -> {
                Object[] options = new Object[]{SharedLocale.tr("button.cancel"), SharedLocale.tr("button.launchAnyway")};
                String message = SharedLocale.tr("runner.wrongJavaVersion", this.instance.getTitle(), javaVersion.getMajorVersion(), javaRuntime.getVersion());
                int picked = JOptionPane.showOptionDialog(null, SwingHelper.htmlWrap(message), SharedLocale.tr("launcher.javaMismatchTitle"), -1, 2, null, options, null);
                return picked == 1;
            });
            try {
                return (Boolean)fut.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public RuntimeVerifier(Instance instance) {
            this.instance = instance;
        }
    }
}

