/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch.runtime;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.PlatformRuntimeFinder;
import com.skcraft.launcher.util.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MacRuntimeFinder
implements PlatformRuntimeFinder {
    private static final Logger log = Logger.getLogger(MacRuntimeFinder.class.getName());

    @Override
    public Set<File> getLauncherDirectories(Environment env) {
        return ImmutableSet.of(new File(System.getenv("HOME"), "Library/Application Support/minecraft"));
    }

    @Override
    public List<File> getCandidateJavaLocations() {
        return Collections.emptyList();
    }

    @Override
    public List<JavaRuntime> getExtraRuntimes() {
        ArrayList<JavaRuntime> entries = Lists.newArrayList();
        try {
            NSObject[] arr;
            Process p = Runtime.getRuntime().exec("/usr/libexec/java_home -X");
            NSArray root = (NSArray)PropertyListParser.parse(p.getInputStream());
            for (NSObject obj : arr = root.getArray()) {
                NSDictionary dict = (NSDictionary)obj;
                entries.add(new JavaRuntime(new File(dict.objectForKey("JVMHomePath").toString()).getAbsoluteFile(), dict.objectForKey("JVMVersion").toString(), MacRuntimeFinder.isArch64Bit(dict.objectForKey("JVMArch").toString())));
            }
        }
        catch (Throwable err) {
            log.log(Level.WARNING, "Failed to parse java_home command", err);
        }
        return entries;
    }

    private static boolean isArch64Bit(String string) {
        return string == null || string.matches("x64|x86_64|amd64|aarch64");
    }
}

