/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lombok.NonNull;

public class SelectionKeeper
implements ListSelectionListener,
ListDataListener {
    private final JList list;
    private Object lastSelected;

    private SelectionKeeper(@NonNull JList list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.list = list;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.list.setSelectedValue(this.lastSelected, true);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.list.setSelectedValue(this.lastSelected, true);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.list.setSelectedValue(this.lastSelected, true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.lastSelected = this.list.getSelectedValue();
        }
    }

    public static void attach(@NonNull JList list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        SelectionKeeper s = new SelectionKeeper(list);
        list.addListSelectionListener(s);
        list.getModel().addListDataListener(s);
    }
}

