/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.loader;

import com.skcraft.launcher.install.InstallExtras;
import com.skcraft.launcher.install.InstallLog;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.install.ProcessorTask;
import com.skcraft.launcher.install.UpdateCache;
import com.skcraft.launcher.model.loader.InstallProcessor;
import com.skcraft.launcher.model.loader.LocalLoader;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.modpack.ManifestEntry;

public class ProcessorEntry
extends ManifestEntry {
    private String loaderName;
    private InstallProcessor processor;

    @Override
    public void install(Installer installer, InstallLog log, UpdateCache cache, InstallExtras extras) throws Exception {
        LocalLoader loader = extras.getLoader(this.loaderName);
        if (this.processor.shouldRunOn(Side.CLIENT)) {
            installer.queueLate(new ProcessorTask(this.processor, loader.getManifest(), this.getManifest(), loader.getLocalFiles()));
        }
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public InstallProcessor getProcessor() {
        return this.processor;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    public void setProcessor(InstallProcessor processor) {
        this.processor = processor;
    }

    @Override
    public String toString() {
        return "ProcessorEntry(loaderName=" + this.getLoaderName() + ", processor=" + this.getProcessor() + ")";
    }

    public ProcessorEntry(String loaderName, InstallProcessor processor) {
        this.loaderName = loaderName;
        this.processor = processor;
    }

    public ProcessorEntry() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessorEntry)) {
            return false;
        }
        ProcessorEntry other = (ProcessorEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$loaderName = this.getLoaderName();
        String other$loaderName = other.getLoaderName();
        if (this$loaderName == null ? other$loaderName != null : !this$loaderName.equals(other$loaderName)) {
            return false;
        }
        InstallProcessor this$processor = this.getProcessor();
        InstallProcessor other$processor = other.getProcessor();
        return !(this$processor == null ? other$processor != null : !((Object)this$processor).equals(other$processor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProcessorEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loaderName = this.getLoaderName();
        result = result * 59 + ($loaderName == null ? 43 : $loaderName.hashCode());
        InstallProcessor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : ((Object)$processor).hashCode());
        return result;
    }
}

