/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.concurrency.ObservableFuture;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.InstanceList;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.dialog.ConfigurationDialog;
import com.skcraft.launcher.dialog.InstanceSettingsDialog;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.launch.LaunchListener;
import com.skcraft.launcher.launch.LaunchOptions;
import com.skcraft.launcher.swing.ActionListeners;
import com.skcraft.launcher.swing.DoubleClickToButtonAdapter;
import com.skcraft.launcher.swing.InstanceTable;
import com.skcraft.launcher.swing.InstanceTableModel;
import com.skcraft.launcher.swing.PopupMouseAdapter;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.WebpagePanel;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import lombok.NonNull;
import net.miginfocom.swing.MigLayout;

public class LauncherFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(LauncherFrame.class.getName());
    private final Launcher launcher;
    private final InstanceTable instancesTable = new InstanceTable();
    private final InstanceTableModel instancesModel;
    private final JScrollPane instanceScroll = new JScrollPane(this.instancesTable);
    private WebpagePanel webView;
    private JSplitPane splitPane;
    private final JButton launchButton = new JButton(SharedLocale.tr("launcher.launch"));
    private final JButton refreshButton = new JButton(SharedLocale.tr("launcher.checkForUpdates"));
    private final JButton optionsButton = new JButton(SharedLocale.tr("launcher.options"));
    private final JButton selfUpdateButton = new JButton(SharedLocale.tr("launcher.updateLauncher"));
    private final JCheckBox updateCheck = new JCheckBox(SharedLocale.tr("launcher.downloadUpdates"));

    public LauncherFrame(@NonNull Launcher launcher) {
        super(SharedLocale.tr("launcher.title", launcher.getVersion()));
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.launcher = launcher;
        this.instancesModel = new InstanceTableModel(launcher.getInstances());
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(400, 300));
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(null);
        SwingHelper.setFrameIcon(this, Launcher.class, "icon.png");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LauncherFrame.this.loadInstances();
            }
        });
    }

    private void initComponents() {
        JPanel container = this.createContainerPanel();
        container.setLayout(new MigLayout("fill, insets dialog", "[][]push[][]", "[grow][]"));
        this.webView = this.createNewsPanel();
        this.splitPane = new JSplitPane(1, this.instanceScroll, this.webView);
        this.selfUpdateButton.setVisible(this.launcher.getUpdateManager().getPendingUpdate());
        this.launcher.getUpdateManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("pendingUpdate")) {
                    LauncherFrame.this.selfUpdateButton.setVisible((Boolean)evt.getNewValue());
                }
            }
        });
        this.updateCheck.setSelected(true);
        this.instancesTable.setModel(this.instancesModel);
        this.launchButton.setFont(this.launchButton.getFont().deriveFont(1));
        this.splitPane.setDividerLocation(200);
        this.splitPane.setDividerSize(4);
        this.splitPane.setOpaque(false);
        container.add((Component)this.splitPane, "grow, wrap, span 5, gapbottom unrel, w null:680, h null:350");
        SwingHelper.flattenJSplitPane(this.splitPane);
        container.add(this.refreshButton);
        container.add(this.updateCheck);
        container.add(this.selfUpdateButton);
        container.add(this.optionsButton);
        container.add(this.launchButton);
        this.add((Component)container, "Center");
        this.instancesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (LauncherFrame.this.instancesTable.getRowCount() > 0) {
                    LauncherFrame.this.instancesTable.setRowSelectionInterval(0, 0);
                }
            }
        });
        this.instancesTable.addMouseListener(new DoubleClickToButtonAdapter(this.launchButton));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.loadInstances();
                LauncherFrame.this.launcher.getUpdateManager().checkForUpdate(LauncherFrame.this);
                LauncherFrame.this.webView.browse(LauncherFrame.this.launcher.getNewsURL(), false);
            }
        });
        this.selfUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.launcher.getUpdateManager().performUpdate(LauncherFrame.this);
            }
        });
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.showOptions();
            }
        });
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.launch();
            }
        });
        this.instancesTable.addMouseListener(new PopupMouseAdapter(){

            @Override
            protected void showPopup(MouseEvent e) {
                int index = LauncherFrame.this.instancesTable.rowAtPoint(e.getPoint());
                Instance selected = null;
                if (index >= 0) {
                    LauncherFrame.this.instancesTable.setRowSelectionInterval(index, index);
                    selected = LauncherFrame.this.launcher.getInstances().get(index);
                }
                LauncherFrame.this.popupInstanceMenu(e.getComponent(), e.getX(), e.getY(), selected);
            }
        });
    }

    protected JPanel createContainerPanel() {
        return new JPanel();
    }

    protected WebpagePanel createNewsPanel() {
        return WebpagePanel.forURL(this.launcher.getNewsURL(), false);
    }

    private void popupInstanceMenu(Component component, int x, int y, final Instance selected) {
        JMenuItem menuItem;
        JPopupMenu popup = new JPopupMenu();
        if (selected != null) {
            menuItem = new JMenuItem(!selected.isLocal() ? SharedLocale.tr("instance.install") : SharedLocale.tr("instance.launch"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LauncherFrame.this.launch();
                }
            });
            popup.add(menuItem);
            if (selected.isLocal()) {
                popup.addSeparator();
                menuItem = new JMenuItem(SharedLocale.tr("instance.openFolder"));
                menuItem.addActionListener(ActionListeners.browseDir(this, selected.getContentDir(), true));
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.openSaves"));
                menuItem.addActionListener(ActionListeners.browseDir(this, new File(selected.getContentDir(), "saves"), true));
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.openResourcePacks"));
                menuItem.addActionListener(ActionListeners.browseDir(this, new File(selected.getContentDir(), "resourcepacks"), true));
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.openScreenshots"));
                menuItem.addActionListener(ActionListeners.browseDir(this, new File(selected.getContentDir(), "screenshots"), true));
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.copyAsPath"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File dir = selected.getContentDir();
                        dir.mkdirs();
                        SwingHelper.setClipboard(dir.getAbsolutePath());
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.openSettings"));
                menuItem.addActionListener(e -> InstanceSettingsDialog.open(this, selected));
                popup.add(menuItem);
                popup.addSeparator();
                if (!selected.isUpdatePending()) {
                    menuItem = new JMenuItem(SharedLocale.tr("instance.forceUpdate"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            selected.setUpdatePending(true);
                            LauncherFrame.this.launch();
                            LauncherFrame.this.instancesModel.update();
                        }
                    });
                    popup.add(menuItem);
                }
                menuItem = new JMenuItem(SharedLocale.tr("instance.hardForceUpdate"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LauncherFrame.this.confirmHardUpdate(selected);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(SharedLocale.tr("instance.deleteFiles"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LauncherFrame.this.confirmDelete(selected);
                    }
                });
                popup.add(menuItem);
            }
            popup.addSeparator();
        }
        menuItem = new JMenuItem(SharedLocale.tr("launcher.refreshList"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.loadInstances();
            }
        });
        popup.add(menuItem);
        popup.show(component, x, y);
    }

    private void confirmDelete(Instance instance) {
        if (!SwingHelper.confirmDialog(this, SharedLocale.tr("instance.confirmDelete", instance.getTitle()), SharedLocale.tr("confirmTitle"))) {
            return;
        }
        ObservableFuture<Instance> future = this.launcher.getInstanceTasks().delete(this, instance);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                LauncherFrame.this.loadInstances();
            }
        }, SwingExecutor.INSTANCE);
    }

    private void confirmHardUpdate(Instance instance) {
        if (!SwingHelper.confirmDialog(this, SharedLocale.tr("instance.confirmHardUpdate"), SharedLocale.tr("confirmTitle"))) {
            return;
        }
        ObservableFuture<Instance> future = this.launcher.getInstanceTasks().hardUpdate(this, instance);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                LauncherFrame.this.launch();
                LauncherFrame.this.instancesModel.update();
            }
        }, SwingExecutor.INSTANCE);
    }

    private void loadInstances() {
        ObservableFuture<InstanceList> future = this.launcher.getInstanceTasks().reloadInstances(this);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                LauncherFrame.this.instancesModel.update();
                if (LauncherFrame.this.instancesTable.getRowCount() > 0) {
                    LauncherFrame.this.instancesTable.setRowSelectionInterval(0, 0);
                }
                LauncherFrame.this.requestFocus();
            }
        }, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this, future, SharedLocale.tr("launcher.checkingTitle"), SharedLocale.tr("launcher.checkingStatus"));
        SwingHelper.addErrorDialogCallback(this, future);
    }

    private void showOptions() {
        ConfigurationDialog configDialog = new ConfigurationDialog((Window)this, this.launcher);
        configDialog.setVisible(true);
    }

    private void launch() {
        boolean permitUpdate = this.updateCheck.isSelected();
        Instance instance = this.launcher.getInstances().get(this.instancesTable.getSelectedRow());
        LaunchOptions options = new LaunchOptions.Builder().setInstance(instance).setListener(new LaunchListenerImpl(this)).setUpdatePolicy(permitUpdate ? LaunchOptions.UpdatePolicy.UPDATE_IF_SESSION_ONLINE : LaunchOptions.UpdatePolicy.NO_UPDATE).setWindow(this).build();
        this.launcher.getLaunchSupervisor().launch(options);
    }

    public InstanceTable getInstancesTable() {
        return this.instancesTable;
    }

    public JScrollPane getInstanceScroll() {
        return this.instanceScroll;
    }

    private static class LaunchListenerImpl
    implements LaunchListener {
        private final WeakReference<LauncherFrame> frameRef;
        private final Launcher launcher;

        private LaunchListenerImpl(LauncherFrame frame) {
            this.frameRef = new WeakReference<LauncherFrame>(frame);
            this.launcher = frame.launcher;
        }

        @Override
        public void instancesUpdated() {
            LauncherFrame frame = (LauncherFrame)this.frameRef.get();
            if (frame != null) {
                frame.instancesModel.update();
            }
        }

        @Override
        public void gameStarted() {
            LauncherFrame frame = (LauncherFrame)this.frameRef.get();
            if (frame != null) {
                frame.dispose();
            }
        }

        @Override
        public void gameClosed() {
            Window newLauncherWindow = this.launcher.showLauncherWindow();
            this.launcher.getUpdateManager().checkForUpdate(newLauncherWindow);
        }
    }
}

