/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IShearable {
    default public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        Shearable shearable;
        IShearable iShearable = this;
        return !(iShearable instanceof Shearable) || (shearable = (Shearable)iShearable).readyForShearing();
    }

    default public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        IShearable iShearable = this;
        if (iShearable instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)iShearable;
            iShearable = this;
            if (iShearable instanceof Shearable) {
                Shearable shearable = (Shearable)iShearable;
                if (!level.isClientSide) {
                    entity.captureDrops(new ArrayList());
                    shearable.shear(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
                    return entity.captureDrops(null).stream().map(ItemEntity::getItem).toList();
                }
            }
        }
        return Collections.emptyList();
    }

    default public void spawnShearedDrop(Level level, BlockPos pos, ItemStack drop) {
        IShearable iShearable = this;
        if (iShearable instanceof SnowGolem) {
            SnowGolem golem = (SnowGolem)iShearable;
            golem.spawnAtLocation(drop, golem.getEyeHeight());
        } else {
            iShearable = this;
            if (iShearable instanceof Bogged) {
                Bogged bogged = (Bogged)iShearable;
                bogged.spawnAtLocation(drop, bogged.getBbHeight());
            } else {
                iShearable = this;
                if (iShearable instanceof MushroomCow) {
                    MushroomCow cow = (MushroomCow)iShearable;
                    itemEntity = cow.spawnAtLocation(drop, cow.getBbHeight());
                    if (itemEntity != null) {
                        itemEntity.setNoPickUpDelay();
                    }
                } else {
                    itemEntity = this;
                    if (itemEntity instanceof Entity) {
                        Entity entity = (Entity)itemEntity;
                        if ((itemEntity = entity.spawnAtLocation(drop, 1.0f)) != null) {
                            RandomSource rand = entity.getRandom();
                            Vec3 newDelta = itemEntity.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f));
                            itemEntity.setDeltaMovement(newDelta);
                        }
                    } else {
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), drop));
                    }
                }
            }
        }
    }
}

