/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BlockCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<BlockCapability<?, ?>> registry = new CapabilityRegistry<BlockCapability>(BlockCapability::new);
    final Map<Block, List<IBlockCapabilityProvider<T, C>>> providers = new IdentityHashMap<Block, List<IBlockCapabilityProvider<T, C>>>();

    public static <T, C> BlockCapability<T, C> create(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        return registry.create(name, typeClass, contextClass);
    }

    public static <T> BlockCapability<T, @Nullable Void> createVoid(ResourceLocation name, Class<T> typeClass) {
        return BlockCapability.create(name, typeClass, Void.TYPE);
    }

    public static <T> BlockCapability<T, @Nullable Direction> createSided(ResourceLocation name, Class<T> typeClass) {
        return BlockCapability.create(name, typeClass, Direction.class);
    }

    public static synchronized List<BlockCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    private BlockCapability(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    @ApiStatus.Internal
    @Nullable
    public T getCapability(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity, C context) {
        pos = pos.immutable();
        if (blockEntity == null) {
            if (state == null) {
                state = level.getBlockState(pos);
            }
            if (state.hasBlockEntity()) {
                blockEntity = level.getBlockEntity(pos);
            }
        } else if (state == null) {
            state = blockEntity.getBlockState();
        }
        for (IBlockCapabilityProvider provider : this.providers.getOrDefault(state.getBlock(), List.of())) {
            Object ret = provider.getCapability(level, pos, state, blockEntity, context);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

