/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.extensions.common;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;

public interface IClientMobEffectExtensions {
    public static final IClientMobEffectExtensions DEFAULT = new IClientMobEffectExtensions(){};

    public static IClientMobEffectExtensions of(MobEffectInstance instance) {
        return IClientMobEffectExtensions.of((MobEffect)instance.getEffect().value());
    }

    public static IClientMobEffectExtensions of(MobEffect effect) {
        return ClientExtensionsManager.MOB_EFFECT_EXTENSIONS.getOrDefault(effect, DEFAULT);
    }

    default public boolean isVisibleInInventory(MobEffectInstance instance) {
        return true;
    }

    default public boolean isVisibleInGui(MobEffectInstance instance) {
        return true;
    }

    default public boolean renderInventoryIcon(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
        return false;
    }

    default public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
        return false;
    }

    default public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics guiGraphics, int x, int y, float z, float alpha) {
        return false;
    }
}

