/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.sounds.Music;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.neoforge.client.ColorResolverManager;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import net.neoforged.neoforge.client.DimensionTransitionScreenManager;
import net.neoforged.neoforge.client.EntitySpectatorShaderManager;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import net.neoforged.neoforge.client.NamedRenderTypeManager;
import net.neoforged.neoforge.client.PresetEditorManager;
import net.neoforged.neoforge.client.RecipeBookManager;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.entity.animation.json.AnimationTypeManager;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientPauseChangeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerChangeGameTypeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMaterialAtlasesEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RegisterSpriteSourceTypesEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ScreenshotEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.event.ToastAddEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.gui.ClientTooltipComponentManager;
import net.neoforged.neoforge.client.gui.map.MapDecorationRendererManager;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.forge.snapshots.ForgeSnapshotsModClient;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final Stack<Screen> guiLayers = new Stack();
    public static String forgeStatusLine;
    private static int slotMainHand;
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions;
    private static final ResourceLocation ICON_SHEET;
    private static final BiMap<ResourceLocation, SpriteSourceType> SPRITE_SOURCE_TYPES_MAP;
    private static boolean initializedClientHooks;
    private static final ExtensionInfo RECIPE_BOOK_TYPE_EXTENSION_INFO;
    private static final RecipeBookType[] RECIPE_BOOK_TYPES;
    private static RecipeBookType @Nullable [] cachedFilteredTypes;

    public static void resizeGuiLayers(Minecraft minecraft, int width, int height) {
        guiLayers.forEach(screen -> screen.resize(minecraft, width, height));
    }

    public static void clearGuiLayers(Minecraft minecraft) {
        while (!guiLayers.isEmpty()) {
            ClientHooks.popGuiLayerInternal(minecraft);
        }
    }

    private static void popGuiLayerInternal(Minecraft minecraft) {
        if (minecraft.screen != null) {
            minecraft.screen.removed();
        }
        minecraft.screen = guiLayers.pop();
    }

    public static void pushGuiLayer(Minecraft minecraft, Screen screen) {
        if (minecraft.screen != null) {
            guiLayers.push(minecraft.screen);
        }
        minecraft.screen = Objects.requireNonNull(screen);
        screen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
        minecraft.getNarrator().sayNow(screen.getNarrationMessage());
    }

    public static void popGuiLayer(Minecraft minecraft) {
        if (guiLayers.isEmpty()) {
            minecraft.setScreen(null);
            return;
        }
        ClientHooks.popGuiLayerInternal(minecraft);
        if (minecraft.screen != null) {
            minecraft.getNarrator().sayNow(minecraft.screen.getNarrationMessage());
        }
    }

    public static float getGuiFarPlane() {
        float depth = 10000.0f * (float)(1 + guiLayers.size());
        if (Minecraft.getInstance().level != null) {
            depth = Math.max(depth, 200.0f * (float)Minecraft.getInstance().gui.getLayerCount());
        }
        return 11000.0f + depth;
    }

    public static ResourceLocation getArmorTexture(Entity entity, ItemStack armor, ArmorMaterial.Layer layer, boolean innerModel, EquipmentSlot slot) {
        ResourceLocation result = armor.getItem().getArmorTexture(armor, entity, slot, layer, innerModel);
        return result != null ? result : layer.texture(innerModel);
    }

    public static boolean onClientPauseChangePre(boolean pause) {
        ClientPauseChangeEvent.Pre event = (ClientPauseChangeEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ClientPauseChangeEvent.Pre(pause));
        return event.isCanceled();
    }

    public static void onClientPauseChangePost(boolean pause) {
        NeoForge.EVENT_BUS.post((Event)new ClientPauseChangeEvent.Post(pause));
    }

    public static boolean onDrawHighlight(LevelRenderer context, Camera camera, HitResult target, DeltaTracker deltaTracker, PoseStack poseStack, MultiBufferSource bufferSource) {
        switch (target.getType()) {
            case BLOCK: {
                if (!(target instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult blockTarget = (BlockHitResult)target;
                return ((RenderHighlightEvent.Block)NeoForge.EVENT_BUS.post((Event)new RenderHighlightEvent.Block(context, camera, blockTarget, deltaTracker, poseStack, bufferSource))).isCanceled();
            }
            case ENTITY: {
                if (!(target instanceof EntityHitResult)) {
                    return false;
                }
                EntityHitResult entityTarget = (EntityHitResult)target;
                NeoForge.EVENT_BUS.post((Event)new RenderHighlightEvent.Entity(context, camera, entityTarget, deltaTracker, poseStack, bufferSource));
                return false;
            }
        }
        return false;
    }

    public static void dispatchRenderStage(RenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int renderTick, Camera camera, Frustum frustum) {
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = mc.getProfiler();
        profiler.push(stage.toString());
        NeoForge.EVENT_BUS.post((Event)new RenderLevelStageEvent(stage, levelRenderer, poseStack, modelViewMatrix, projectionMatrix, renderTick, mc.getTimer(), camera, frustum));
        profiler.pop();
    }

    public static void dispatchRenderStage(RenderType renderType, LevelRenderer levelRenderer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int renderTick, Camera camera, Frustum frustum) {
        RenderLevelStageEvent.Stage stage = RenderLevelStageEvent.Stage.fromRenderType(renderType);
        if (stage != null) {
            ClientHooks.dispatchRenderStage(stage, levelRenderer, null, modelViewMatrix, projectionMatrix, renderTick, camera, frustum);
        }
    }

    public static boolean renderSpecificFirstPersonHand(InteractionHand hand, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return ((RenderHandEvent)NeoForge.EVENT_BUS.post((Event)new RenderHandEvent(hand, poseStack, bufferSource, packedLight, partialTick, interpPitch, swingProgress, equipProgress, stack))).isCanceled();
    }

    public static boolean renderSpecificFirstPersonArm(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AbstractClientPlayer player, HumanoidArm arm) {
        return ((RenderArmEvent)NeoForge.EVENT_BUS.post((Event)new RenderArmEvent(poseStack, multiBufferSource, packedLight, player, arm))).isCanceled();
    }

    public static void onTextureAtlasStitched(TextureAtlas atlas) {
        ModLoader.postEvent((Event)new TextureAtlasStitchedEvent(atlas));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        ModLoader.postEvent((Event)new RegisterColorHandlersEvent.Block(blockColors));
    }

    public static void onItemColorsInit(ItemColors itemColors, BlockColors blockColors) {
        ModLoader.postEvent((Event)new RegisterColorHandlersEvent.Item(itemColors, blockColors));
    }

    public static Model getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot slot, HumanoidModel<?> _default) {
        return IClientItemExtensions.of(itemStack).getGenericArmorModel(entityLiving, itemStack, slot, _default);
    }

    public static <T extends LivingEntity> void copyModelProperties(HumanoidModel<T> original, HumanoidModel<?> replacement) {
        original.copyPropertiesTo(replacement);
        replacement.head.visible = original.head.visible;
        replacement.hat.visible = original.hat.visible;
        replacement.body.visible = original.body.visible;
        replacement.rightArm.visible = original.rightArm.visible;
        replacement.leftArm.visible = original.leftArm.visible;
        replacement.rightLeg.visible = original.rightLeg.visible;
        replacement.leftLeg.visible = original.leftLeg.visible;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    public static float getFieldOfViewModifier(Player entity, float fovModifier) {
        ComputeFovModifierEvent fovModifierEvent = new ComputeFovModifierEvent(entity, fovModifier);
        NeoForge.EVENT_BUS.post((Event)fovModifierEvent);
        return fovModifierEvent.getNewFovModifier();
    }

    public static double getFieldOfView(GameRenderer renderer, Camera camera, double partialTick, double fov, boolean usedConfiguredFov) {
        ViewportEvent.ComputeFov event = new ViewportEvent.ComputeFov(renderer, camera, partialTick, fov, usedConfiguredFov);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getFOV();
    }

    public static CalculatePlayerTurnEvent getTurnPlayerValues(double mouseSensitivity, boolean cinematicCameraEnabled) {
        CalculatePlayerTurnEvent event = new CalculatePlayerTurnEvent(mouseSensitivity, cinematicCameraEnabled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static float getDetachedCameraDistance(Camera camera, boolean flipped, float entityScale, float distance) {
        CalculateDetachedCameraDistanceEvent event = new CalculateDetachedCameraDistanceEvent(camera, flipped, entityScale, distance);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getDistance();
    }

    public static void renderMainMenu(TitleScreen gui, GuiGraphics guiGraphics, Font font, int width, int height, int alpha) {
        ForgeSnapshotsModClient.renderMainMenuWarning(NeoForgeVersion.getVersion(), guiGraphics, font, width, height, alpha);
        forgeStatusLine = switch (NeoForgeVersion.getStatus()) {
            case VersionChecker.Status.OUTDATED, VersionChecker.Status.BETA_OUTDATED -> I18n.get((String)"neoforge.update.newversion", (Object[])new Object[]{NeoForgeVersion.getTarget()});
            default -> null;
        };
    }

    @Nullable
    public static SoundInstance playSound(SoundEngine manager, SoundInstance sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        NeoForge.EVENT_BUS.post((Event)e);
        return e.getSound();
    }

    @Nullable
    public static Music selectMusic(Music situational, @Nullable SoundInstance playing) {
        SelectMusicEvent e = new SelectMusicEvent(situational, playing);
        NeoForge.EVENT_BUS.post((Event)e);
        return e.getMusic();
    }

    public static void drawScreen(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiLayers.forEach(layer -> {
            ClientHooks.drawScreenInternal(layer, guiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
            guiGraphics.pose().translate(0.0f, 0.0f, 10000.0f);
        });
        ClientHooks.drawScreenInternal(screen, guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().popPose();
    }

    private static void drawScreenInternal(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((ScreenEvent.Render.Pre)NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Render.Pre(screen, guiGraphics, mouseX, mouseY, partialTick))).isCanceled()) {
            screen.renderWithTooltip(guiGraphics, mouseX, mouseY, partialTick);
        }
        NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Render.Post(screen, guiGraphics, mouseX, mouseY, partialTick));
    }

    public static Vector3f getFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, float fogRed, float fogGreen, float fogBlue) {
        FluidState state = level.getFluidState(camera.getBlockPosition());
        Vector3f fluidFogColor = new Vector3f(fogRed, fogGreen, fogBlue);
        if (camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + state.getHeight((BlockGetter)level, camera.getBlockPosition()))) {
            fluidFogColor = IClientFluidTypeExtensions.of(state).modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        }
        ViewportEvent.ComputeFogColor event = new ViewportEvent.ComputeFogColor(camera, partialTick, fluidFogColor.x(), fluidFogColor.y(), fluidFogColor.z());
        NeoForge.EVENT_BUS.post((Event)event);
        fluidFogColor.set(event.getRed(), event.getGreen(), event.getBlue());
        return fluidFogColor;
    }

    public static void onFogRender(FogRenderer.FogMode mode, FogType type, Camera camera, float partialTick, float renderDistance, float nearDistance, float farDistance, FogShape shape) {
        ViewportEvent.RenderFog event;
        FluidState state = camera.getEntity().level().getFluidState(camera.getBlockPosition());
        if (camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + state.getHeight((BlockGetter)camera.getEntity().level(), camera.getBlockPosition()))) {
            IClientFluidTypeExtensions.of(state).modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
        }
        if (((ViewportEvent.RenderFog)NeoForge.EVENT_BUS.post((Event)(event = new ViewportEvent.RenderFog(mode, type, camera, partialTick, nearDistance, farDistance, shape)))).isCanceled()) {
            RenderSystem.setShaderFogStart((float)event.getNearPlaneDistance());
            RenderSystem.setShaderFogEnd((float)event.getFarPlaneDistance());
            RenderSystem.setShaderFogShape((FogShape)event.getFogShape());
        }
    }

    public static void onModifyBakingResult(Map<ModelResourceLocation, BakedModel> models, Map<ResourceLocation, AtlasSet.StitchResult> stitchResults, ModelBakery modelBakery) {
        Function<Material, TextureAtlasSprite> textureGetter = material -> {
            AtlasSet.StitchResult stitchResult = (AtlasSet.StitchResult)stitchResults.get(material.atlasLocation());
            TextureAtlasSprite sprite = stitchResult.getSprite(material.texture());
            if (sprite != null) {
                return sprite;
            }
            LOGGER.warn("Failed to retrieve texture '{}' from atlas '{}'", (Object)material.texture(), (Object)material.atlasLocation(), (Object)new Throwable());
            return stitchResult.missing();
        };
        ModLoader.postEvent((Event)new ModelEvent.ModifyBakingResult(models, textureGetter, modelBakery));
    }

    public static void onModelBake(ModelManager modelManager, Map<ModelResourceLocation, BakedModel> models, ModelBakery modelBakery) {
        ModLoader.postEvent((Event)new ModelEvent.BakingCompleted(modelManager, Collections.unmodifiableMap(models), modelBakery));
    }

    public static BakedModel handleCameraTransforms(PoseStack poseStack, BakedModel model, ItemDisplayContext cameraTransformType, boolean applyLeftHandTransform) {
        model = model.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        return model;
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, loc);
    }

    public static void fillNormal(int[] faceData, Direction facing) {
        Vector3f v1 = ClientHooks.getVertexPos(faceData, 3);
        Vector3f t1 = ClientHooks.getVertexPos(faceData, 1);
        Vector3f v2 = ClientHooks.getVertexPos(faceData, 2);
        Vector3f t2 = ClientHooks.getVertexPos(faceData, 0);
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        int x = (byte)Math.round(v2.x() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.y() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.z() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 8;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static boolean calculateFaceWithoutAO(BlockAndTintGetter getter, BlockState state, BlockPos pos, BakedQuad quad, boolean isFaceCubic, float[] brightness, int[] lightmap) {
        if (quad.hasAmbientOcclusion()) {
            return false;
        }
        BlockPos lightmapPos = isFaceCubic ? pos.relative(quad.getDirection()) : pos;
        brightness[2] = brightness[3] = getter.getShade(quad.getDirection(), quad.isShade());
        brightness[1] = brightness[3];
        brightness[0] = brightness[3];
        lightmap[2] = lightmap[3] = LevelRenderer.getLightColor((BlockAndTintGetter)getter, (BlockState)state, (BlockPos)lightmapPos);
        lightmap[1] = lightmap[3];
        lightmap[0] = lightmap[3];
        return true;
    }

    public static void loadEntityShader(Entity entity, GameRenderer entityRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = EntitySpectatorShaderManager.get(entity.getType())) != null) {
            entityRenderer.loadEffect(shader);
        }
    }

    public static boolean shouldCauseReequipAnimation(ItemStack from, ItemStack to, int slot) {
        boolean fromInvalid = from.isEmpty();
        boolean toInvalid = to.isEmpty();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.getItem().shouldCauseReequipAnimation(from, to, changed);
    }

    public static CustomizeGuiOverlayEvent.BossEventProgress onCustomizeBossEventProgress(GuiGraphics guiGraphics, Window window, LerpingBossEvent bossInfo, int x, int y, int increment) {
        CustomizeGuiOverlayEvent.BossEventProgress evt = new CustomizeGuiOverlayEvent.BossEventProgress(window, guiGraphics, Minecraft.getInstance().getTimer(), bossInfo, x, y, increment);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static ScreenshotEvent onScreenshot(NativeImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onClientChangeGameType(PlayerInfo info, GameType currentGameMode, GameType newGameMode) {
        if (currentGameMode != newGameMode) {
            ClientPlayerChangeGameTypeEvent evt = new ClientPlayerChangeGameTypeEvent(info, currentGameMode, newGameMode);
            NeoForge.EVENT_BUS.post((Event)evt);
        }
    }

    public static void onMovementInputUpdate(Player player, Input movementInput) {
        NeoForge.EVENT_BUS.post((Event)new MovementInputUpdateEvent(player, movementInput));
    }

    public static boolean onScreenMouseClickedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        ScreenEvent.MouseButtonPressed.Pre event = new ScreenEvent.MouseButtonPressed.Pre(guiScreen, mouseX, mouseY, button);
        return ((ScreenEvent.MouseButtonPressed.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenMouseClickedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        ScreenEvent.MouseButtonPressed.Post event = new ScreenEvent.MouseButtonPressed.Post(guiScreen, mouseX, mouseY, button, handled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getClickResult();
    }

    public static boolean onScreenMouseReleasedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        ScreenEvent.MouseButtonReleased.Pre event = new ScreenEvent.MouseButtonReleased.Pre(guiScreen, mouseX, mouseY, button);
        return ((ScreenEvent.MouseButtonReleased.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenMouseReleasedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        ScreenEvent.MouseButtonReleased.Post event = new ScreenEvent.MouseButtonReleased.Post(guiScreen, mouseX, mouseY, button, handled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getReleaseResult();
    }

    public static boolean onScreenMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        ScreenEvent.MouseDragged.Pre event = new ScreenEvent.MouseDragged.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return ((ScreenEvent.MouseDragged.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        ScreenEvent.MouseDragged.Post event = new ScreenEvent.MouseDragged.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onScreenMouseScrollPre(MouseHandler mouseHelper, Screen guiScreen, double scrollDeltaX, double scrollDeltaY) {
        Window mainWindow = guiScreen.getMinecraft().getWindow();
        double mouseX = mouseHelper.xpos() * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getScreenWidth();
        double mouseY = mouseHelper.ypos() * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getScreenHeight();
        ScreenEvent.MouseScrolled.Pre event = new ScreenEvent.MouseScrolled.Pre(guiScreen, mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        return ((ScreenEvent.MouseScrolled.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenMouseScrollPost(MouseHandler mouseHelper, Screen guiScreen, double scrollDeltaX, double scrollDeltaY) {
        Window mainWindow = guiScreen.getMinecraft().getWindow();
        double mouseX = mouseHelper.xpos() * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getScreenWidth();
        double mouseY = mouseHelper.ypos() * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getScreenHeight();
        ScreenEvent.MouseScrolled.Post event = new ScreenEvent.MouseScrolled.Post(guiScreen, mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onScreenKeyPressedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyPressed.Pre event = new ScreenEvent.KeyPressed.Pre(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyPressed.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyPressedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyPressed.Post event = new ScreenEvent.KeyPressed.Post(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyPressed.Post)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyReleasedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyReleased.Pre event = new ScreenEvent.KeyReleased.Pre(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyReleased.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyReleasedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyReleased.Post event = new ScreenEvent.KeyReleased.Post(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyReleased.Post)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenCharTypedPre(Screen guiScreen, char codePoint, int modifiers) {
        ScreenEvent.CharacterTyped.Pre event = new ScreenEvent.CharacterTyped.Pre(guiScreen, codePoint, modifiers);
        return ((ScreenEvent.CharacterTyped.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenCharTypedPost(Screen guiScreen, char codePoint, int modifiers) {
        ScreenEvent.CharacterTyped.Post event = new ScreenEvent.CharacterTyped.Post(guiScreen, codePoint, modifiers);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static void onRecipesUpdated(RecipeManager mgr) {
        RecipesUpdatedEvent event = new RecipesUpdatedEvent(mgr);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onMouseButtonPre(int button, int action, int mods) {
        return ((InputEvent.MouseButton.Pre)NeoForge.EVENT_BUS.post((Event)new InputEvent.MouseButton.Pre(button, action, mods))).isCanceled();
    }

    public static void onMouseButtonPost(int button, int action, int mods) {
        NeoForge.EVENT_BUS.post((Event)new InputEvent.MouseButton.Post(button, action, mods));
    }

    public static boolean onMouseScroll(MouseHandler mouseHelper, double scrollDeltaX, double scrollDeltaY) {
        InputEvent.MouseScrollingEvent event = new InputEvent.MouseScrollingEvent(scrollDeltaX, scrollDeltaY, mouseHelper.isLeftPressed(), mouseHelper.isMiddlePressed(), mouseHelper.isRightPressed(), mouseHelper.xpos(), mouseHelper.ypos());
        return ((InputEvent.MouseScrollingEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        NeoForge.EVENT_BUS.post((Event)new InputEvent.Key(key, scanCode, action, modifiers));
    }

    public static InputEvent.InteractionKeyMappingTriggered onClickInput(int button, KeyMapping keyBinding, InteractionHand hand) {
        InputEvent.InteractionKeyMappingTriggered event = new InputEvent.InteractionKeyMappingTriggered(button, keyBinding, hand);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean isNameplateInRenderDistance(Entity entity, double squareDistance) {
        if (entity instanceof LivingEntity) {
            double value = ((LivingEntity)entity).getAttributeValue(NeoForgeMod.NAMETAG_DISTANCE);
            return !(squareDistance > value * value);
        }
        return !(squareDistance > 4096.0);
    }

    public static void renderPistonMovedBlocks(BlockPos pos, BlockState state, PoseStack stack, MultiBufferSource bufferSource, Level level, boolean checkSides, int packedOverlay, BlockRenderDispatcher blockRenderer) {
        BakedModel model = blockRenderer.getBlockModel(state);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)state.getSeed(pos)), ModelData.EMPTY)) {
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType(renderType));
            blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, state, pos, stack, vertexConsumer, checkSides, RandomSource.create(), state.getSeed(pos), packedOverlay, ModelData.EMPTY, renderType);
        }
    }

    public static boolean shouldRenderEffect(MobEffectInstance effectInstance) {
        return IClientMobEffectExtensions.of(effectInstance).isVisibleInInventory(effectInstance);
    }

    public static void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
        layerDefinitions.put(layerLocation, supplier);
    }

    public static void loadLayerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> builder) {
        layerDefinitions.forEach((k, v) -> builder.put(k, (Object)((LayerDefinition)v.get())));
    }

    public static void firePlayerLogin(MultiPlayerGameMode pc, LocalPlayer player, Connection networkManager) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggingIn(pc, player, networkManager));
    }

    public static void firePlayerLogout(@Nullable MultiPlayerGameMode pc, @Nullable LocalPlayer player) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggingOut(pc, player, player != null ? (player.connection != null ? player.connection.getConnection() : null) : null));
    }

    public static void firePlayerRespawn(MultiPlayerGameMode pc, LocalPlayer oldPlayer, LocalPlayer newPlayer, Connection networkManager) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.Clone(pc, oldPlayer, newPlayer, networkManager));
    }

    public static void onRegisterParticleProviders(ParticleEngine particleEngine) {
        ModLoader.postEvent((Event)new RegisterParticleProvidersEvent(particleEngine));
    }

    public static void onRegisterKeyMappings(Options options) {
        ModLoader.postEvent((Event)new RegisterKeyMappingsEvent(options));
    }

    public static void onRegisterAdditionalModels(Set<ModelResourceLocation> additionalModels) {
        ModLoader.postEvent((Event)new ModelEvent.RegisterAdditional(additionalModels));
    }

    @Nullable
    public static Component onClientChat(ChatType.Bound boundChatType, Component message, UUID sender) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(boundChatType, message, sender);
        return ((ClientChatReceivedEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientPlayerChat(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage, UUID sender) {
        ClientChatReceivedEvent.Player event = new ClientChatReceivedEvent.Player(boundChatType, message, playerChatMessage, sender);
        return ((ClientChatReceivedEvent.Player)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientSystemChat(Component message, boolean overlay) {
        ClientChatReceivedEvent.System event = new ClientChatReceivedEvent.System(message, overlay);
        return ((ClientChatReceivedEvent.System)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    public static String onClientSendMessage(String message) {
        ClientChatEvent event = new ClientChatEvent(message);
        return ((ClientChatEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? "" : event.getMessage();
    }

    public static RenderType getEntityRenderType(RenderType chunkRenderType, boolean cull) {
        return RenderTypeHelper.getEntityRenderType(chunkRenderType, cull);
    }

    public static Font getTooltipFont(ItemStack stack, Font fallbackFont) {
        Font stackFont = IClientItemExtensions.of(stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        return stackFont == null ? fallbackFont : stackFont;
    }

    public static RenderTooltipEvent.Pre onRenderTooltipPre(ItemStack stack, GuiGraphics graphics, int x, int y, int screenWidth, int screenHeight, List<ClientTooltipComponent> components, Font fallbackFont, ClientTooltipPositioner positioner) {
        RenderTooltipEvent.Pre preEvent = new RenderTooltipEvent.Pre(stack, graphics, x, y, screenWidth, screenHeight, ClientHooks.getTooltipFont(stack, fallbackFont), components, positioner);
        NeoForge.EVENT_BUS.post((Event)preEvent);
        return preEvent;
    }

    public static RenderTooltipEvent.Color onRenderTooltipColor(ItemStack stack, GuiGraphics graphics, int x, int y, Font font, List<ClientTooltipComponent> components) {
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, graphics, x, y, font, -267386864, 0x505000FF, 1344798847, components);
        NeoForge.EVENT_BUS.post((Event)colorEvent);
        return colorEvent;
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        return ClientHooks.gatherTooltipComponents(stack, textElements, Optional.empty(), mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        return ClientHooks.gatherTooltipComponentsFromElements(stack, elements, mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponentsFromElements(ItemStack stack, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ClientHooks.getTooltipFont(stack, fallbackFont);
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(stack, screenWidth, screenHeight, elements, -1);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> ClientHooks.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
        }
        return event.getTooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), ClientTooltipComponent::create)).toList();
    }

    private static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.getVisualOrderText()).map(ClientTooltipComponent::create);
        }
        return font.split(text, maxWidth).stream().map(ClientTooltipComponent::create);
    }

    public static Comparator<ParticleRenderType> makeParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    public static ScreenEvent.RenderInventoryMobEffects onScreenPotionSize(Screen screen, int availableSpace, boolean compact, int horizontalOffset) {
        ScreenEvent.RenderInventoryMobEffects event = new ScreenEvent.RenderInventoryMobEffects(screen, availableSpace, compact, horizontalOffset);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean onToastAdd(Toast toast) {
        return ((ToastAddEvent)NeoForge.EVENT_BUS.post((Event)new ToastAddEvent(toast))).isCanceled();
    }

    public static boolean isBlockInSolidLayer(BlockState state) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        return model.getRenderTypes(state, RandomSource.create(), ModelData.EMPTY).contains(RenderType.solid());
    }

    public static boolean renderFireOverlay(Player player, PoseStack mat) {
        return ClientHooks.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.FIRE, Blocks.FIRE.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderWaterOverlay(Player player, PoseStack mat) {
        return ClientHooks.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.WATER, Blocks.WATER.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderBlockOverlay(Player player, PoseStack mat, RenderBlockScreenEffectEvent.OverlayType type, BlockState block, BlockPos pos) {
        return ((RenderBlockScreenEffectEvent)NeoForge.EVENT_BUS.post((Event)new RenderBlockScreenEffectEvent(player, mat, type, block, pos))).isCanceled();
    }

    public static int getMaxMipmapLevel(int width, int height) {
        return Math.min(Mth.log2((int)Math.max(1, width)), Mth.log2((int)Math.max(1, height)));
    }

    public static ResourceLocation getShaderImportLocation(String basePath, boolean isRelative, String importPath) {
        ResourceLocation loc = ResourceLocation.parse((String)importPath);
        String normalised = FileUtil.normalizeResourcePath((String)((isRelative ? basePath : "shaders/include/") + loc.getPath()));
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)normalised);
    }

    public static BiMap<ResourceLocation, SpriteSourceType> makeSpriteSourceTypesMap() {
        return SPRITE_SOURCE_TYPES_MAP;
    }

    @ApiStatus.Internal
    public static void registerSpriteSourceTypes() {
        ModLoader.postEvent((Event)new RegisterSpriteSourceTypesEvent(SPRITE_SOURCE_TYPES_MAP));
    }

    @ApiStatus.Internal
    public static <T extends BlockEntity> boolean isBlockEntityRendererVisible(BlockEntityRenderDispatcher dispatcher, BlockEntity blockEntity, Frustum frustum) {
        BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
        return renderer != null && frustum.isVisible(renderer.getRenderBoundingBox(blockEntity));
    }

    public static List<BlockElement> fixItemModelSeams(List<BlockElement> elements, TextureAtlasSprite sprite) {
        float expand = -sprite.uvShrinkRatio();
        for (BlockElement element : elements) {
            Map.Entry faceEntry;
            if (element.faces.size() != 1 || ((Direction)(faceEntry = element.faces.entrySet().iterator().next()).getKey()).getAxis() == Direction.Axis.Z) continue;
            element.from.x = Mth.clamp((float)Mth.lerp((float)expand, (float)element.from.x, (float)8.0f), (float)0.0f, (float)16.0f);
            element.from.y = Mth.clamp((float)Mth.lerp((float)expand, (float)element.from.y, (float)8.0f), (float)0.0f, (float)16.0f);
            element.to.x = Mth.clamp((float)Mth.lerp((float)expand, (float)element.to.x, (float)8.0f), (float)0.0f, (float)16.0f);
            element.to.y = Mth.clamp((float)Mth.lerp((float)expand, (float)element.to.y, (float)8.0f), (float)0.0f, (float)16.0f);
            float[] uv = ((BlockElementFace)faceEntry.getValue()).uv().uvs;
            if (((Direction)faceEntry.getKey()).getAxis() == Direction.Axis.Y) {
                float centerU = (uv[0] + uv[0] + uv[2] + uv[2]) / 4.0f;
                uv[0] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[0], (float)centerU), (float)0.0f, (float)16.0f);
                uv[2] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[2], (float)centerU), (float)0.0f, (float)16.0f);
                continue;
            }
            float centerV = (uv[1] + uv[1] + uv[3] + uv[3]) / 4.0f;
            uv[1] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[1], (float)centerV), (float)0.0f, (float)16.0f);
            uv[3] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[3], (float)centerV), (float)0.0f, (float)16.0f);
        }
        return elements;
    }

    public static List<AddSectionGeometryEvent.AdditionalSectionRenderer> gatherAdditionalRenderers(BlockPos sectionOrigin, Level level) {
        AddSectionGeometryEvent event = new AddSectionGeometryEvent(sectionOrigin, level);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getAdditionalRenderers();
    }

    public static void addAdditionalGeometry(List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers, Function<RenderType, VertexConsumer> getOrCreateBuilder, RenderChunkRegion region, PoseStack transformation) {
        if (additionalRenderers.isEmpty()) {
            return;
        }
        AddSectionGeometryEvent.SectionRenderingContext context = new AddSectionGeometryEvent.SectionRenderingContext(getOrCreateBuilder, (BlockAndTintGetter)region, transformation);
        for (AddSectionGeometryEvent.AdditionalSectionRenderer renderer : additionalRenderers) {
            renderer.render(context);
        }
    }

    @ApiStatus.Internal
    public static void initClientHooks(Minecraft mc, ReloadableResourceManager resourceManager) {
        if (initializedClientHooks) {
            throw new IllegalStateException("Client hooks initialized more than once");
        }
        initializedClientHooks = true;
        ClientExtensionsManager.init();
        GameTestHooks.registerGametests();
        ClientHooks.registerSpriteSourceTypes();
        MenuScreens.init();
        ModLoader.postEvent((Event)new RegisterClientReloadListenersEvent(resourceManager));
        ModLoader.postEvent((Event)new EntityRenderersEvent.RegisterLayerDefinitions());
        ModLoader.postEvent((Event)new EntityRenderersEvent.RegisterRenderers());
        ClientTooltipComponentManager.init();
        EntitySpectatorShaderManager.init();
        ClientHooks.onRegisterKeyMappings(mc.options);
        RecipeBookManager.init();
        mc.gui.initModdedOverlays();
        DimensionSpecialEffectsManager.init();
        NamedRenderTypeManager.init();
        ColorResolverManager.init();
        ItemDecoratorHandler.init();
        PresetEditorManager.init();
        MapDecorationRendererManager.init();
        DimensionTransitionScreenManager.init();
        AnimationTypeManager.init();
    }

    public static void fireRenderFramePre(DeltaTracker partialTick) {
        NeoForge.EVENT_BUS.post((Event)new RenderFrameEvent.Pre(partialTick));
    }

    public static void fireRenderFramePost(DeltaTracker partialRick) {
        NeoForge.EVENT_BUS.post((Event)new RenderFrameEvent.Post(partialRick));
    }

    public static void fireClientTickPre() {
        NeoForge.EVENT_BUS.post((Event)new ClientTickEvent.Pre());
    }

    public static void fireClientTickPost() {
        NeoForge.EVENT_BUS.post((Event)new ClientTickEvent.Post());
    }

    @Nullable
    public static <T> HolderLookup.RegistryLookup<T> resolveLookup(ResourceKey<? extends Registry<T>> key) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return level.registryAccess().lookup(key).orElse(null);
        }
        return null;
    }

    public static List<Component> getEffectTooltip(EffectRenderingInventoryScreen<?> screen, MobEffectInstance effectInst, List<Component> tooltip) {
        GatherEffectScreenTooltipsEvent event = new GatherEffectScreenTooltipsEvent(screen, effectInst, tooltip);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getTooltip();
    }

    public static RecipeBookType[] getFilteredRecipeBookTypeValues() {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        if (listener != null && !listener.getConnection().isMemoryConnection() && listener.getConnectionType().isOther()) {
            if (cachedFilteredTypes == null) {
                cachedFilteredTypes = RECIPE_BOOK_TYPE_EXTENSION_INFO.extended() ? Arrays.copyOfRange(RECIPE_BOOK_TYPES, 0, RECIPE_BOOK_TYPE_EXTENSION_INFO.vanillaCount()) : RECIPE_BOOK_TYPES;
            }
            return cachedFilteredTypes;
        }
        return RECIPE_BOOK_TYPES;
    }

    public static void reloadRenderer() {
        Minecraft.getInstance().levelRenderer.allChanged();
    }

    public static Map<ResourceLocation, ResourceLocation> gatherMaterialAtlases(Map<ResourceLocation, ResourceLocation> vanillaAtlases) {
        vanillaAtlases = new HashMap<ResourceLocation, ResourceLocation>(vanillaAtlases);
        ModLoader.postEvent((Event)new RegisterMaterialAtlasesEvent(vanillaAtlases));
        return Map.copyOf(vanillaAtlases);
    }

    static {
        slotMainHand = 0;
        layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        ICON_SHEET = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/icons.png");
        SPRITE_SOURCE_TYPES_MAP = HashBiMap.create();
        initializedClientHooks = false;
        RECIPE_BOOK_TYPE_EXTENSION_INFO = RecipeBookType.getExtensionInfo();
        RECIPE_BOOK_TYPES = RecipeBookType.values();
        cachedFilteredTypes = null;
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="neoforge", bus=EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @Nullable
        private static ShaderInstance rendertypeEntityTranslucentUnlitShader;

        public static ShaderInstance getEntityTranslucentUnlitShader() {
            return Objects.requireNonNull(rendertypeEntityTranslucentUnlitShader, "Attempted to call getEntityTranslucentUnlitShader before shaders have finished loading.");
        }

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"rendertype_entity_unlit_translucent"), DefaultVertexFormat.NEW_ENTITY), p_172645_ -> {
                rendertypeEntityTranslucentUnlitShader = p_172645_;
            });
        }
    }
}

