/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.installertools.Task;
import net.neoforged.installertools.util.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ExtractInheritance
extends Task {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{2}).setPrettyPrinting().create();
    private Map<String, ClassInfo> inClasses = new HashMap<String, ClassInfo>();
    private Map<String, ClassInfo> libClasses = new HashMap<String, ClassInfo>();
    private Set<String> failedClasses = new HashSet<String>();

    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec libraryO = parser.accepts("lib").withRequiredArg().ofType(File.class);
        OptionSpecBuilder annotationsO = parser.accepts("annotations");
        PROGRESS.setIndeterminate(true);
        try {
            OptionSet options = parser.parse(args);
            File input = ((File)options.valueOf((OptionSpec)inputO)).getAbsoluteFile();
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean annotations = options.has((OptionSpec)annotationsO);
            this.log("Input:  " + input);
            this.log("Output: " + output);
            this.log("Ann:    " + annotations);
            if (!input.exists()) {
                this.error("Missing required input jar: " + input);
            }
            if (output.exists()) {
                output.delete();
            }
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            output.createNewFile();
            this.log("Reading Input: " + input);
            this.readJar(input, this.inClasses, annotations);
            for (File lib : options.valuesOf((OptionSpec)libraryO)) {
                this.log("Reading Library: " + lib);
                this.readJar(lib, this.libClasses, annotations);
            }
            PROGRESS.setIndeterminate(false);
            PROGRESS.setMaxProgress(this.inClasses.size());
            int am = 0;
            for (Map.Entry<String, ClassInfo> entry : this.inClasses.entrySet()) {
                this.resolveClass(entry.getValue(), annotations);
                if (++am % 10 != 0) continue;
                PROGRESS.setProgress(am);
            }
            PROGRESS.setProgress(am);
            Files.write(output.toPath(), GSON.toJson(this.inClasses).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.log("Process complete");
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private void readJar(File input, Map<String, ClassInfo> classes, boolean annotations) throws IOException {
        try (ZipFile inJar = new ZipFile(input);){
            Utils.forZip(inJar, entry -> {
                if (!entry.getName().endsWith(".class") || entry.getName().startsWith(".")) {
                    return;
                }
                ClassReader reader = new ClassReader(Utils.toByteArray(inJar.getInputStream((ZipEntry)entry)));
                ClassNode classNode = new ClassNode();
                reader.accept((ClassVisitor)classNode, 0);
                ClassInfo info = new ClassInfo(classNode, annotations);
                classes.put(info.name, info);
            });
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Could not open input file: " + e.getMessage());
        }
    }

    private void resolveClass(ClassInfo cls, boolean annotations) {
        if (cls == null || cls.resolved) {
            return;
        }
        if (!cls.name.equals("java/lang/Object") && cls.superName != null) {
            this.resolveClass(this.getClassInfo(cls.superName, annotations), annotations);
        }
        if (cls.interfaces != null) {
            for (String intf2 : cls.interfaces) {
                this.resolveClass(this.getClassInfo(intf2, annotations), annotations);
            }
        }
        if (cls.methods != null) {
            for (MethodInfo mtd : cls.methods.values()) {
                if ("<init>".equals(mtd.getName()) || "<cinit>".equals(mtd.getName()) || (mtd.access & 0xA) != 0) continue;
                MethodInfo override = null;
                ArrayDeque<ClassInfo> que = new ArrayDeque<ClassInfo>();
                HashSet<String> processed = new HashSet<String>();
                if (cls.superName != null) {
                    this.addQueue(cls.superName, processed, que, annotations);
                }
                if (cls.interfaces != null) {
                    cls.interfaces.forEach(intf -> this.addQueue((String)intf, (Set<String>)processed, (Queue<ClassInfo>)que, annotations));
                }
                while (!que.isEmpty()) {
                    ClassInfo c = (ClassInfo)que.poll();
                    if (c.superName != null) {
                        this.addQueue(c.superName, processed, que, annotations);
                    }
                    if (c.interfaces != null) {
                        c.interfaces.forEach(intf -> this.addQueue((String)intf, (Set<String>)processed, (Queue<ClassInfo>)que, annotations));
                    }
                    MethodInfo m = c.getMethod(mtd.getName(), mtd.getDesc());
                    int bad_flags = 26;
                    if (m == null || (m.access & bad_flags) != 0) continue;
                    override = m;
                }
                if (override == null) continue;
                mtd.override = override.getParent().name;
            }
        }
        cls.resolved = true;
    }

    private void addQueue(String cls, Set<String> visited, Queue<ClassInfo> que, boolean annotations) {
        if (!visited.contains(cls)) {
            ClassInfo ci = this.getClassInfo(cls, annotations);
            if (ci != null) {
                que.add(ci);
            }
            visited.add(cls);
        }
    }

    private ClassInfo getClassInfo(String name, boolean annotations) {
        ClassInfo ret = this.inClasses.get(name);
        if (ret != null) {
            return ret;
        }
        ret = this.libClasses.get(name);
        if (ret == null && !this.failedClasses.contains(name)) {
            try {
                Class<?> cls = Class.forName(name.replaceAll("/", "."), false, this.getClass().getClassLoader());
                ret = new ClassInfo(cls, annotations);
                this.libClasses.put(name, ret);
            }
            catch (ClassNotFoundException ex) {
                this.log("Cant Find Class: " + name);
                this.failedClasses.add(name);
            }
        }
        return ret;
    }

    @SafeVarargs
    private static List<AnnotationInfo> getAnnotations(List<AnnotationNode> ... lists) {
        ArrayList<AnnotationInfo> ret = new ArrayList<AnnotationInfo>();
        for (List<AnnotationNode> list : lists) {
            if (list == null) continue;
            list.stream().map(x$0 -> new AnnotationInfo((AnnotationNode)x$0)).forEach(ret::add);
        }
        Collections.sort(ret);
        return ret.isEmpty() ? null : ret;
    }

    private static List<AnnotationInfo> getAnnotations(Annotation[] anns) {
        ArrayList<AnnotationInfo> ret = new ArrayList<AnnotationInfo>();
        if (anns != null && anns.length > 0) {
            Arrays.stream(anns).map(x$0 -> new AnnotationInfo((Annotation)x$0)).forEach(ret::add);
        }
        Collections.sort(ret);
        return ret.isEmpty() ? null : ret;
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new);
    }

    public static class AnnotationInfo
    implements Comparable<AnnotationInfo> {
        public final String desc;

        private AnnotationInfo(AnnotationNode node) {
            this.desc = node.desc;
        }

        private AnnotationInfo(Annotation node) {
            this.desc = Type.getDescriptor(node.annotationType());
        }

        @Override
        public int compareTo(AnnotationInfo o) {
            return this.desc.compareTo(o.desc);
        }
    }

    public static class Bouncer {
        public final String name;
        public final String desc;

        public Bouncer(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    private static class MethodInfo {
        private final String name;
        private final String desc;
        public final int access;
        public List<String> exceptions;
        private final ClassInfo parent;
        public final Bouncer bouncer;
        public String override = null;
        public final List<AnnotationInfo> annotations;

        MethodInfo(ClassInfo parent, MethodNode node, boolean annotations) {
            this.name = node.name;
            this.desc = node.desc;
            this.access = node.access;
            this.exceptions = node.exceptions.isEmpty() ? null : new ArrayList(node.exceptions);
            this.parent = parent;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(new List[]{node.visibleAnnotations, node.invisibleAnnotations}) : null;
            Bouncer bounce = null;
            if ((node.access & 0x1040) != 0 && (node.access & 8) == 0) {
                AbstractInsnNode start = node.instructions.getFirst();
                if (start instanceof LabelNode && start.getNext() instanceof LineNumberNode) {
                    start = start.getNext().getNext();
                }
                if (start instanceof VarInsnNode) {
                    VarInsnNode n = (VarInsnNode)start;
                    if (n.var == 0 && n.getOpcode() == 25) {
                        AbstractInsnNode end = node.instructions.getLast();
                        if (end instanceof LabelNode) {
                            end = end.getPrevious();
                        }
                        if (end.getOpcode() >= 172 && end.getOpcode() <= 177) {
                            end = end.getPrevious();
                        }
                        if (end instanceof MethodInsnNode) {
                            while (start != end) {
                                if (!(start instanceof VarInsnNode) && start.getOpcode() != 193 && start.getOpcode() != 192) {
                                    end = null;
                                    break;
                                }
                                start = start.getNext();
                            }
                            MethodInsnNode mtd = (MethodInsnNode)end;
                            if (end != null && mtd.owner.equals(parent.name) && Type.getArgumentsAndReturnSizes((String)node.desc) == Type.getArgumentsAndReturnSizes((String)mtd.desc)) {
                                bounce = new Bouncer(mtd.name, mtd.desc);
                            }
                        }
                    }
                }
            }
            this.bouncer = bounce;
        }

        MethodInfo(ClassInfo parent, Method node, boolean annotations) {
            this.name = node.getName();
            this.desc = Type.getMethodDescriptor((Method)node);
            this.access = node.getModifiers();
            ArrayList<String> execs = new ArrayList<String>();
            for (Class<?> e : node.getExceptionTypes()) {
                execs.add(e.getName().replace('.', '/'));
            }
            this.exceptions = execs.isEmpty() ? null : execs;
            this.parent = parent;
            this.bouncer = null;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(node.getDeclaredAnnotations()) : null;
        }

        MethodInfo(ClassInfo parent, Constructor<?> node, boolean annotations) {
            this.name = "<init>";
            this.desc = Type.getConstructorDescriptor(node);
            this.access = node.getModifiers();
            ArrayList<String> execs = new ArrayList<String>();
            for (Class<?> e : node.getExceptionTypes()) {
                execs.add(e.getName().replace('.', '/'));
            }
            this.exceptions = execs.isEmpty() ? null : execs;
            this.parent = parent;
            this.bouncer = null;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(node.getDeclaredAnnotations()) : null;
        }

        public ClassInfo getParent() {
            return this.parent;
        }

        public String toString() {
            return this.parent.name + "/" + this.name + this.desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    private static class FieldInfo {
        private final String name;
        public final String desc;
        public final int access;
        public final List<AnnotationInfo> annotations;

        public FieldInfo(FieldNode node, boolean annotations) {
            this.name = node.name;
            this.desc = node.desc;
            this.access = node.access;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(new List[]{node.visibleAnnotations, node.invisibleAnnotations}) : null;
        }

        public FieldInfo(Field node, boolean annotations) {
            this.name = node.getName();
            this.desc = Type.getType(node.getType()).getDescriptor();
            this.access = node.getModifiers();
            this.annotations = annotations ? ExtractInheritance.getAnnotations(node.getDeclaredAnnotations()) : null;
        }
    }

    private static class ClassInfo {
        public final String name;
        public final int access;
        public final String superName;
        public final List<String> interfaces;
        public final Map<String, MethodInfo> methods;
        public final Map<String, FieldInfo> fields;
        public final List<AnnotationInfo> annotations;
        private boolean resolved = false;

        private Map<String, MethodInfo> makeMap(List<MethodInfo> lst) {
            if (lst.isEmpty()) {
                return null;
            }
            TreeMap<String, MethodInfo> ret = new TreeMap<String, MethodInfo>();
            lst.forEach(info -> ret.put(info.getName() + " " + info.getDesc(), (MethodInfo)info));
            return ret;
        }

        ClassInfo(ClassNode node, boolean annotations) {
            this.name = node.name;
            this.access = node.access;
            this.superName = node.superName;
            this.interfaces = node.interfaces.isEmpty() ? null : node.interfaces;
            ArrayList<MethodInfo> lst = new ArrayList<MethodInfo>();
            if (!node.methods.isEmpty()) {
                node.methods.forEach(mn -> lst.add(new MethodInfo(this, (MethodNode)mn, annotations)));
            }
            this.methods = this.makeMap(lst);
            this.fields = !node.fields.isEmpty() ? node.fields.stream().map(fn -> new FieldInfo((FieldNode)fn, annotations)).collect(ExtractInheritance.toTreeMap(e -> ((FieldInfo)e).name, e -> e)) : null;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(new List[]{node.visibleAnnotations, node.invisibleAnnotations}) : null;
        }

        ClassInfo(Class<?> node, boolean annotations) {
            this.name = node.getName().replace('.', '/');
            this.access = node.getModifiers();
            this.superName = node.getSuperclass() == null ? null : node.getSuperclass().getName().replace('.', '/');
            ArrayList<String> intfs = new ArrayList<String>();
            for (Class<?> i : node.getInterfaces()) {
                intfs.add(i.getName().replace('.', '/'));
            }
            this.interfaces = intfs.isEmpty() ? null : intfs;
            ArrayList<MethodInfo> mtds = new ArrayList<MethodInfo>();
            for (Constructor<?> constructor : node.getConstructors()) {
                mtds.add(new MethodInfo(this, constructor, annotations));
            }
            for (Executable executable : node.getDeclaredMethods()) {
                mtds.add(new MethodInfo(this, (Method)executable, annotations));
            }
            this.methods = this.makeMap(mtds);
            Field[] flds = node.getDeclaredFields();
            this.fields = flds != null && flds.length > 0 ? Arrays.asList(flds).stream().map(fn -> new FieldInfo((Field)fn, annotations)).collect(ExtractInheritance.toTreeMap(e -> ((FieldInfo)e).name, e -> e)) : null;
            this.annotations = annotations ? ExtractInheritance.getAnnotations(node.getDeclaredAnnotations()) : null;
        }

        public MethodInfo getMethod(String name, String desc) {
            return this.methods == null ? null : this.methods.get(name + " " + desc);
        }
    }
}

