/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.List;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.i18n.FMLTranslations;

public class ModLoadingException
extends RuntimeException {
    private final List<ModLoadingIssue> issues;

    public ModLoadingException(ModLoadingIssue issue) {
        this(List.of(issue));
    }

    public ModLoadingException(List<ModLoadingIssue> issues) {
        this.issues = issues;
    }

    public List<ModLoadingIssue> getIssues() {
        return this.issues;
    }

    @Override
    public String getMessage() {
        List<ModLoadingIssue> warnings;
        StringBuilder result = new StringBuilder();
        List<ModLoadingIssue> errors = this.issues.stream().filter(i -> i.severity() == ModLoadingIssue.Severity.ERROR).toList();
        if (!errors.isEmpty()) {
            result.append("Loading errors encountered:\n");
            for (ModLoadingIssue error : errors) {
                this.appendIssue(error, result);
            }
        }
        if (!(warnings = this.issues.stream().filter(i -> i.severity() == ModLoadingIssue.Severity.WARNING).toList()).isEmpty()) {
            result.append("Loading warnings encountered:\n");
            for (ModLoadingIssue warning : warnings) {
                this.appendIssue(warning, result);
            }
        }
        return result.toString();
    }

    private void appendIssue(ModLoadingIssue issue, StringBuilder result) {
        String translation;
        try {
            translation = FMLTranslations.stripControlCodes(FMLTranslations.translateIssueEnglish(issue));
        }
        catch (Exception e) {
            translation = issue.toString();
        }
        translation = translation.replace("\n", "\n\t  ");
        result.append("\t- ").append(translation).append("\n");
    }
}

