/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.relocated.net.neoforged.cliutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

public class JarUtils {
    public static int getFileCountInZip(File path) throws IOException {
        long c = 0L;
        try (FileSystem fs = FileSystems.newFileSystem(path.toPath(), null);){
            for (Path root : fs.getRootDirectories()) {
                Stream<Path> count = Files.find(root, Integer.MAX_VALUE, (p, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    c += count.count();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (count == null) continue;
                    if (throwable != null) {
                        try {
                            count.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    count.close();
                }
            }
        }
        return c > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)c;
    }
}

