/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.crafting;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;

public final class CompoundFluidIngredient
extends FluidIngredient {
    public static final MapCodec<CompoundFluidIngredient> CODEC = NeoForgeExtraCodecs.aliasedFieldOf(FluidIngredient.LIST_CODEC_NON_EMPTY, "children", "ingredients").xmap(CompoundFluidIngredient::new, CompoundFluidIngredient::children);
    private final List<FluidIngredient> children;

    public CompoundFluidIngredient(List<? extends FluidIngredient> children) {
        if (children.isEmpty()) {
            throw new IllegalArgumentException("Compound fluid ingredient must have at least one child");
        }
        this.children = List.copyOf(children);
    }

    public static FluidIngredient of(FluidIngredient ... children) {
        if (children.length == 0) {
            return FluidIngredient.empty();
        }
        if (children.length == 1) {
            return children[0];
        }
        return new CompoundFluidIngredient(List.of(children));
    }

    public static FluidIngredient of(List<FluidIngredient> children) {
        if (children.isEmpty()) {
            return FluidIngredient.empty();
        }
        if (children.size() == 1) {
            return children.getFirst();
        }
        return new CompoundFluidIngredient(children);
    }

    public static FluidIngredient of(Stream<FluidIngredient> stream) {
        return CompoundFluidIngredient.of(stream.toList());
    }

    @Override
    public Stream<FluidStack> generateStacks() {
        return this.children.stream().flatMap(FluidIngredient::generateStacks);
    }

    @Override
    public boolean test(FluidStack stack) {
        for (FluidIngredient child : this.children) {
            if (!child.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSimple() {
        for (FluidIngredient child : this.children) {
            if (child.isSimple()) continue;
            return false;
        }
        return true;
    }

    @Override
    public FluidIngredientType<?> getType() {
        return NeoForgeMod.COMPOUND_FLUID_INGREDIENT_TYPE.get();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundFluidIngredient)) return false;
        CompoundFluidIngredient other = (CompoundFluidIngredient)obj;
        if (!other.children.equals(this.children)) return false;
        return true;
    }

    public List<FluidIngredient> children() {
        return this.children;
    }
}

