/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.LockHelper;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class EventListenerHelper {
    private static final LockHelper<Class<?>, ListenerList> listeners = new LockHelper(new IdentityHashMap());
    private static final ListenerList EVENTS_LIST = new ListenerList();
    private static final LockHelper<Class<?>, Boolean> cancelable = new LockHelper(new IdentityHashMap());
    private static final LockHelper<Class<?>, Boolean> hasResult = new LockHelper(new IdentityHashMap());

    public static ListenerList getListenerList(Class<?> eventClass) {
        return EventListenerHelper.getListenerListInternal(eventClass, false);
    }

    static ListenerList getListenerListInternal(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return EVENTS_LIST;
        }
        return listeners.computeIfAbsent(eventClass, () -> EventListenerHelper.computeListenerList(eventClass, fromInstanceCall));
    }

    private static ListenerList computeListenerList(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return new ListenerList();
        }
        if (fromInstanceCall || Modifier.isAbstract(eventClass.getModifiers())) {
            Class<?> superclass = eventClass.getSuperclass();
            ListenerList parentList = EventListenerHelper.getListenerList(superclass);
            return new ListenerList(parentList);
        }
        try {
            Constructor<?> ctr = eventClass.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            return event.getListenerList();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error computing listener list for " + eventClass.getName(), e);
        }
    }

    private static void clearAll() {
        listeners.clearAll();
    }

    static boolean isCancelable(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Cancelable.class, cancelable);
    }

    static boolean hasResult(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Event.HasResult.class, hasResult);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, LockHelper<Class<?>, Boolean> lock) {
        if (eventClass == Event.class) {
            return false;
        }
        return lock.computeIfAbsent(eventClass, () -> {
            Class parent = eventClass.getSuperclass();
            return eventClass.isAnnotationPresent(annotation) || parent != null && EventListenerHelper.hasAnnotation(parent, annotation, lock);
        });
    }
}

