/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import net.minecraftforge.eventbus.ClassLoaderFactory;
import net.minecraftforge.eventbus.LockHelper;
import org.objectweb.asm.tree.ClassNode;

public class ModLauncherFactory
extends ClassLoaderFactory {
    private static final LockHelper<String, Method> PENDING = new LockHelper(new HashMap());
    private Optional<ClassLoader> gameClassLoader = null;

    @Override
    protected Class<?> createWrapper(Method callback) throws ClassNotFoundException {
        this.enqueueWrapper(callback);
        String name = this.getUniqueName(callback);
        return Class.forName(name, true, this.getClassLoader());
    }

    private void enqueueWrapper(Method callback) {
        String name = this.getUniqueName(callback);
        PENDING.computeIfAbsent(name, () -> callback);
    }

    public static boolean hasPendingWrapperClass(String className) {
        return PENDING.containsKey(className);
    }

    public static void processWrapperClass(String className, ClassNode node) {
        Method meth = PENDING.get(className);
        ModLauncherFactory.transformNode(className, meth, node);
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        if (this.gameClassLoader == null) {
            ModuleLayer gameLayer = (ModuleLayer)Launcher.INSTANCE.findLayerManager().flatMap(lm -> lm.getLayer(IModuleLayerManager.Layer.GAME)).orElseThrow();
            this.gameClassLoader = gameLayer.modules().stream().findFirst().map(Module::getClassLoader);
        }
        return this.gameClassLoader.orElse(null);
    }
}

