/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import net.minecraftforge.coremod.CoreMod;
import net.minecraftforge.coremod.NashornFactory;
import net.minecraftforge.forgespi.coremod.ICoreModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CoreModEngine {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker COREMOD = MarkerManager.getMarker((String)"COREMOD");
    private List<CoreMod> coreMods = new ArrayList<CoreMod>();
    static final Set<String> ALLOWED_PACKAGES = Set.of("java.util", "java.util.function", "org.objectweb.asm.util");
    static final Set<String> ALLOWED_CLASSES = Set.of("net.minecraftforge.coremod.api.ASMAPI", "org.objectweb.asm.Opcodes", "org.objectweb.asm.tree.AbstractInsnNode", "org.objectweb.asm.tree.FieldInsnNode", "org.objectweb.asm.tree.FrameNode", "org.objectweb.asm.tree.IincInsnNode", "org.objectweb.asm.tree.InsnNode", "org.objectweb.asm.tree.IntInsnNode", "org.objectweb.asm.tree.InsnList", "org.objectweb.asm.tree.InvokeDynamicInsnNode", "org.objectweb.asm.tree.JumpInsnNode", "org.objectweb.asm.tree.LabelNode", "org.objectweb.asm.tree.LdcInsnNode", "org.objectweb.asm.tree.LineNumberNode", "org.objectweb.asm.tree.LocalVariableAnnotationNode", "org.objectweb.asm.tree.LocalVariableNode", "org.objectweb.asm.tree.LookupSwitchInsnNode", "org.objectweb.asm.tree.MethodInsnNode", "org.objectweb.asm.tree.MultiANewArrayInsnNode", "org.objectweb.asm.tree.TableSwitchInsnNode", "org.objectweb.asm.tree.TryCatchBlockNode", "org.objectweb.asm.tree.TypeAnnotationNode", "org.objectweb.asm.tree.TypeInsnNode", "org.objectweb.asm.tree.VarInsnNode", "org.objectweb.asm.tree.FieldNode", "org.objectweb.asm.tree.MethodNode", "org.objectweb.asm.tree.ParameterNode", "org.objectweb.asm.Attribute", "org.objectweb.asm.Handle", "org.objectweb.asm.Label", "org.objectweb.asm.Type", "org.objectweb.asm.TypePath", "org.objectweb.asm.TypeReference");
    public static final boolean DO_NOT_FIX_INSNBEFORE;

    void loadCoreMod(ICoreModFile coremod) {
        ScriptEngine scriptEngine = NashornFactory.createEngine();
        ScriptContext jsContext = scriptEngine.getContext();
        jsContext.removeAttribute("load", jsContext.getAttributesScope("load"));
        jsContext.removeAttribute("quit", jsContext.getAttributesScope("quit"));
        jsContext.removeAttribute("loadWithNewGlobal", jsContext.getAttributesScope("loadWithNewGlobal"));
        jsContext.removeAttribute("exit", jsContext.getAttributesScope("exit"));
        this.coreMods.add(new CoreMod(coremod, scriptEngine));
    }

    static boolean checkClass(String s) {
        return ALLOWED_CLASSES.contains(s) || s.lastIndexOf(46) != -1 && ALLOWED_PACKAGES.contains(s.substring(0, s.lastIndexOf(46)));
    }

    public List<ITransformer<?>> initializeCoreMods() {
        for (CoreMod coreMod : this.coreMods) {
            this.initialize(coreMod);
        }
        return this.coreMods.stream().map(CoreMod::buildTransformers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initialize(CoreMod coreMod) {
        LOGGER.debug(COREMOD, "Loading CoreMod from {}", (Object)coreMod.getPath());
        coreMod.initialize();
        if (coreMod.hasError()) {
            LOGGER.error(COREMOD, "Error occurred initializing CoreMod", (Throwable)coreMod.getError());
        } else {
            LOGGER.debug(COREMOD, "CoreMod loaded successfully");
        }
    }

    static {
        Optional blackboardVar = Launcher.INSTANCE.blackboard().get(TypesafeMap.Key.getOrCreate((TypesafeMap)Launcher.INSTANCE.blackboard(), (String)"coremods.use_old_findFirstInstructionBefore", Boolean.class));
        DO_NOT_FIX_INSNBEFORE = blackboardVar.isPresent() && (Boolean)blackboardVar.get() != false;
        if (DO_NOT_FIX_INSNBEFORE) {
            LOGGER.debug("CoreMods will preserve legacy behavior of ASMAPI.findFirstInstructionBefore for backwards-compatibility");
        }
    }
}

