/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.Optional;
import net.minecraftforge.eventbus.LogMarkers;
import net.minecraftforge.eventbus.Names;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventSubclassTransformer {
    private static final Logger LOGGER = LogManager.getLogger();
    private Optional<ClassLoader> gameClassLoader = null;

    public Optional<ClassNode> transform(ClassNode classNode, Type classType) {
        try {
            if ("Lnet/minecraftforge/eventbus/api/Event;".equals(classType.getDescriptor())) {
                this.transformEvent(classNode);
            } else if (!this.buildEvents(classNode)) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            LOGGER.error(LogMarkers.EVENTBUS, "An error occurred building event handler", (Throwable)e);
        }
        return Optional.of(classNode);
    }

    private void transformEvent(ClassNode cls) throws Exception {
        for (MethodNode method : cls.methods) {
            if (!Names.CANCELABLE_M.equals(method) && !Names.HAS_RESULT_M.equals(method)) continue;
            EventSubclassTransformer.clear(method);
            method.instructions.add((AbstractInsnNode)new InsnNode(3));
            method.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        this.addListenerList(cls, false);
    }

    private static void clear(MethodNode mtd) {
        mtd.instructions.clear();
        mtd.localVariables.clear();
        if (mtd.tryCatchBlocks != null) {
            mtd.tryCatchBlocks.clear();
        }
        if (mtd.visibleLocalVariableAnnotations != null) {
            mtd.visibleLocalVariableAnnotations.clear();
        }
        if (mtd.invisibleLocalVariableAnnotations != null) {
            mtd.invisibleLocalVariableAnnotations.clear();
        }
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        Class<?> parent = null;
        ClassLoader loader = this.getClassLoader();
        try {
            parent = loader.loadClass(classNode.superName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(LogMarkers.EVENTBUS, "Could not find parent {} for class {} in classloader {} on thread {}", (Object)classNode.superName, (Object)classNode.name, (Object)loader, (Object)Thread.currentThread());
            throw e;
        }
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform begin: {}", (Object)classNode.name);
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        boolean hasCancelable = false;
        boolean hasResult = false;
        for (MethodNode method : classNode.methods) {
            if ((method.access & 1) == 1) {
                if (Names.LISTENER_LIST_GET.equals(method)) {
                    hasGetListenerList = true;
                } else if (Names.CANCELABLE_M.equals(method)) {
                    hasCancelable = true;
                } else if (Names.HAS_RESULT_M.equals(method)) {
                    hasResult = true;
                }
            }
            if (!Names.INIT_M.equals(method)) continue;
            hasDefaultCtr = true;
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode node : classNode.visibleAnnotations) {
                MethodNode method;
                if (!hasResult && node.desc.equals("Lnet/minecraftforge/eventbus/api/Event$HasResult;")) {
                    method = new MethodNode(1, Names.HAS_RESULT_M.name(), Names.HAS_RESULT_M.desc(), null, null);
                    method.instructions.add((AbstractInsnNode)new InsnNode(4));
                    method.instructions.add((AbstractInsnNode)new InsnNode(172));
                    classNode.methods.add(method);
                    hasResult = true;
                    continue;
                }
                if (hasCancelable || !node.desc.equals("Lnet/minecraftforge/eventbus/api/Cancelable;")) continue;
                method = new MethodNode(1, Names.CANCELABLE_M.name(), Names.CANCELABLE_M.desc(), null, null);
                method.instructions.add((AbstractInsnNode)new InsnNode(4));
                method.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method);
                hasCancelable = true;
            }
        }
        if (parent == Event.class) {
            MethodNode method;
            if (!hasResult) {
                method = new MethodNode(1, Names.HAS_RESULT_M.name(), Names.HAS_RESULT_M.desc(), null, null);
                method.instructions.add((AbstractInsnNode)new InsnNode(3));
                method.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method);
            }
            if (!hasCancelable) {
                method = new MethodNode(1, Names.CANCELABLE_M.name(), Names.CANCELABLE_M.desc(), null, null);
                method.instructions.add((AbstractInsnNode)new InsnNode(3));
                method.instructions.add((AbstractInsnNode)new InsnNode(172));
                classNode.methods.add(method);
            }
        }
        Type tSuper = Type.getObjectType((String)classNode.superName);
        if (!hasDefaultCtr) {
            MethodNode method;
            method = new MethodNode(1, Names.INIT_M.name(), Names.INIT_M.desc(), null, null);
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), Names.INIT_M.name(), Names.INIT_M.desc(), false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method);
        }
        if (hasGetListenerList) {
            LOGGER.debug(LogMarkers.EVENTBUS, "Transforming event complete - already done: {}", (Object)classNode.name);
            return true;
        }
        return this.addListenerList(classNode, true);
    }

    private boolean addListenerList(ClassNode classNode, boolean useSuper) {
        Type tList = Type.getType((String)"Lnet/minecraftforge/eventbus/ListenerList;");
        Type tHelper = Type.getType((String)"Lnet/minecraftforge/eventbus/api/EventListenerHelper;");
        Type tThis = Type.getObjectType((String)classNode.name);
        classNode.fields.add(new FieldNode(26, Names.LISTENER_LIST_F.name(), Names.LISTENER_LIST_F.desc(), null, null));
        InsnList clinit = new InsnList();
        clinit.add((AbstractInsnNode)new TypeInsnNode(187, tList.getInternalName()));
        clinit.add((AbstractInsnNode)new InsnNode(89));
        if (useSuper) {
            clinit.add((AbstractInsnNode)new LdcInsnNode((Object)tThis));
            clinit.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getSuperclass", "()Ljava/lang/Class;", false));
            clinit.add((AbstractInsnNode)new MethodInsnNode(184, tHelper.getInternalName(), "getListenerList", Type.getMethodDescriptor((Type)tList, (Type[])new Type[]{Type.getType(Class.class)}), false));
            clinit.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), Names.LISTENER_LIST_INIT.name(), Names.LISTENER_LIST_INIT.desc(), false));
        } else {
            clinit.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), Names.INIT_M.name(), Names.INIT_M.desc(), false));
        }
        clinit.add((AbstractInsnNode)new FieldInsnNode(179, tThis.getInternalName(), Names.LISTENER_LIST_F.name(), Names.LISTENER_LIST_F.desc()));
        MethodNode method = classNode.methods.stream().filter(Names.STATIC_INIT_M::equals).findFirst().orElse(null);
        if (method == null) {
            method = new MethodNode(8, Names.STATIC_INIT_M.name(), Names.STATIC_INIT_M.desc(), null, null);
            method.instructions.add(clinit);
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(method);
        } else {
            method.instructions.insert(clinit);
        }
        method = classNode.methods.stream().filter(Names.LISTENER_LIST_GET::equals).findFirst().orElse(null);
        if (method == null) {
            method = new MethodNode(1, Names.LISTENER_LIST_GET.name(), Names.LISTENER_LIST_GET.desc(), null, null);
            classNode.methods.add(method);
        } else {
            EventSubclassTransformer.clear(method);
        }
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, Names.LISTENER_LIST_F.name(), Names.LISTENER_LIST_F.desc()));
        method.instructions.add((AbstractInsnNode)new InsnNode(176));
        LOGGER.debug(LogMarkers.EVENTBUS, "Event transform complete: {}", (Object)classNode.name);
        return true;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getGameClassLoader();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    private ClassLoader getGameClassLoader() {
        if (this.gameClassLoader == null) {
            ModuleLayer gameLayer = (ModuleLayer)Launcher.INSTANCE.findLayerManager().flatMap(lm -> lm.getLayer(IModuleLayerManager.Layer.GAME)).orElseThrow();
            this.gameClassLoader = gameLayer.modules().stream().findFirst().map(Module::getClassLoader);
        }
        return this.gameClassLoader.orElse(null);
    }
}

