/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DevEnvUtils {
    private DevEnvUtils() {
    }

    public static List<Path> findFileSystemRootsOfFileOnClasspath(String relativePath) {
        Iterator<URL> resourceIt;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (DevEnvUtils.class.getModule().isNamed()) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            resourceIt = classLoader.getResources(relativePath).asIterator();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to enumerate classpath locations of " + relativePath);
        }
        ArrayList<Path> result = new ArrayList<Path>();
        while (resourceIt.hasNext()) {
            Path resourcePath;
            URL resourceUrl = resourceIt.next();
            if ("jar".equals(resourceUrl.getProtocol())) {
                URI fileUri = URI.create(resourceUrl.toString().split("!")[0].substring("jar:".length()));
                result.add(Paths.get(fileUri));
                continue;
            }
            try {
                resourcePath = Paths.get(resourceUrl.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to convert " + String.valueOf(resourceUrl) + " to URI");
            }
            for (Path current = Paths.get(relativePath, new String[0]); current != null; current = current.getParent()) {
                if ((resourcePath = resourcePath.getParent()) != null) continue;
                throw new IllegalArgumentException("Resource " + String.valueOf(resourceUrl) + " did not have same nesting depth as " + relativePath);
            }
            result.add(resourcePath);
        }
        return result;
    }

    public static Path findFileSystemRootOfFileOnClasspath(String relativePath) {
        List<Path> paths = DevEnvUtils.findFileSystemRootsOfFileOnClasspath(relativePath);
        if (paths.isEmpty()) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.failed_to_find_on_classpath", relativePath));
        }
        if (paths.size() > 1) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.multiple_copies_on_classpath", relativePath, paths));
        }
        return paths.getFirst();
    }
}

