/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.capability.wrappers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BucketPickupHandlerWrapper
implements IFluidHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Player player;
    protected final BucketPickup bucketPickupHandler;
    protected final Level world;
    protected final BlockPos blockPos;

    public BucketPickupHandlerWrapper(Player player, BucketPickup bucketPickupHandler, Level world, BlockPos blockPos) {
        this.player = player;
        this.bucketPickupHandler = bucketPickupHandler;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        FluidState fluidState;
        if (tank == 0 && !(fluidState = this.world.getFluidState(this.blockPos)).isEmpty()) {
            return new FluidStack(fluidState.getType(), 1000);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidState fluidState;
        if (!resource.isEmpty() && 1000 <= resource.getAmount() && !(fluidState = this.world.getFluidState(this.blockPos)).isEmpty() && resource.is(fluidState.getType())) {
            if (action.execute()) {
                Item item;
                ItemStack itemStack = this.bucketPickupHandler.pickupBlock(this.player, (LevelAccessor)this.world, this.blockPos, this.world.getBlockState(this.blockPos));
                if (itemStack != ItemStack.EMPTY && (item = itemStack.getItem()) instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)item;
                    FluidStack extracted = new FluidStack(bucket.content, 1000);
                    if (!FluidStack.isSameFluidSameComponents(resource, extracted)) {
                        LOGGER.error("Fluid removed without successfully being picked up. Fluid {} at {} in {} matched requested type, but after performing pickup was {}.", (Object)BuiltInRegistries.FLUID.getKey((Object)fluidState.getType()), (Object)this.blockPos, (Object)this.world.dimension().location(), (Object)BuiltInRegistries.FLUID.getKey((Object)bucket.content));
                        return FluidStack.EMPTY;
                    }
                    return extracted;
                }
            } else {
                FluidStack extracted = new FluidStack(fluidState.getType(), 1000);
                if (FluidStack.isSameFluid(resource, extracted)) {
                    return extracted;
                }
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidState fluidState;
        if (1000 <= maxDrain && !(fluidState = this.world.getFluidState(this.blockPos)).isEmpty()) {
            Item item;
            if (action.simulate()) {
                return new FluidStack(fluidState.getType(), 1000);
            }
            ItemStack itemStack = this.bucketPickupHandler.pickupBlock(this.player, (LevelAccessor)this.world, this.blockPos, this.world.getBlockState(this.blockPos));
            if (itemStack != ItemStack.EMPTY && (item = itemStack.getItem()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                return new FluidStack(bucket.content, 1000);
            }
        }
        return FluidStack.EMPTY;
    }
}

