/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record InsertingContents(int index) implements ComponentContents
{
    public static final MapCodec<InsertingContents> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("index").forGetter(InsertingContents::index)).apply((Applicative)i, InsertingContents::new));
    public static final ComponentContents.Type<InsertingContents> TYPE = new ComponentContents.Type(CODEC, "neoforge:inserting");
    private static final ThreadLocal<Deque<TranslatableContents>> TRANSLATION_STACK = ThreadLocal.withInitial(ArrayDeque::new);

    @ApiStatus.Internal
    public static boolean pushTranslation(TranslatableContents contents) {
        for (TranslatableContents other : TRANSLATION_STACK.get()) {
            if (contents != other) continue;
            return false;
        }
        TRANSLATION_STACK.get().push(contents);
        return true;
    }

    @ApiStatus.Internal
    public static void popTranslation() {
        TRANSLATION_STACK.get().pop();
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        TranslatableContents translation = TRANSLATION_STACK.get().peek();
        if (translation == null || translation.getArgs().length <= this.index) {
            return visitor.accept("%" + (this.index + 1) + "$s");
        }
        Object arg = translation.getArgs()[this.index];
        if (arg instanceof Component) {
            Component component = (Component)arg;
            return component.visit(visitor);
        }
        return visitor.accept(arg.toString());
    }

    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> visitor, Style style) {
        TranslatableContents translation = TRANSLATION_STACK.get().peek();
        if (translation == null || translation.getArgs().length <= this.index) {
            return visitor.accept(style, "%" + (this.index + 1) + "$s");
        }
        Object arg = translation.getArgs()[this.index];
        if (arg instanceof Component) {
            Component component = (Component)arg;
            return component.visit(visitor, style);
        }
        return visitor.accept(style, arg.toString());
    }

    public ComponentContents.Type<?> type() {
        return TYPE;
    }
}

