/*
 * Decompiled with CFR 0.152.
 */
package net.jojosolos.flightconduit.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.jojosolos.flightconduit.block.entity.FlightConduitBlockEntity;
import net.jojosolos.flightconduit.block.entity.client.ModModelLayers;
import net.minecraft.client.Camera;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class FlightConduitBlockEntityRenderer
implements BlockEntityRenderer<FlightConduitBlockEntity> {
    public static final Material SHELL_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_base"));
    public static final Material ACTIVE_SHELL_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_cage"));
    public static final Material WIND_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_wind"));
    public static final Material VERTICAL_WIND_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_wind_vertical"));
    public static final Material OPEN_EYE_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_open_eye"));
    public static final Material CLOSED_EYE_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("flightconduit", "entity/conduit/flight_closed_eye"));
    private final ModelPart eye;
    private final ModelPart wind;
    private final ModelPart shell;
    private final ModelPart cage;
    private final BlockEntityRenderDispatcher renderer;

    public FlightConduitBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.renderer = pContext.m_173581_();
        this.eye = pContext.m_173582_(ModModelLayers.FLIGHT_CONDUIT_EYE);
        this.wind = pContext.m_173582_(ModModelLayers.FLIGHT_CONDUIT_WIND);
        this.shell = pContext.m_173582_(ModModelLayers.FLIGHT_CONDUIT_SHELL);
        this.cage = pContext.m_173582_(ModModelLayers.FLIGHT_CONDUIT_CAGE);
    }

    public static LayerDefinition createEyeLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public static LayerDefinition createWindLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("wind", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition createShellLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public static LayerDefinition createCageLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void render(FlightConduitBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        float f = (float)pBlockEntity.tickCount + pPartialTick;
        if (!pBlockEntity.isActive()) {
            float f5 = pBlockEntity.getActiveRotation(0.0f);
            VertexConsumer vertexconsumer1 = SHELL_TEXTURE.m_119194_(pBuffer, RenderType::m_110446_);
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, 0.5f, 0.5f);
            pPoseStack.m_252781_(new Quaternionf().rotationY(f5 * ((float)Math.PI / 180)));
            this.shell.m_104301_(pPoseStack, vertexconsumer1, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
        } else {
            float f1 = pBlockEntity.getActiveRotation(pPartialTick) * 57.295776f;
            float f2 = Mth.m_14031_((float)(f * 0.1f)) / 2.0f + 0.5f;
            f2 = f2 * f2 + f2;
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
            pPoseStack.m_252781_(new Quaternionf().rotationAxis(f1 * ((float)Math.PI / 180), (Vector3fc)vector3f));
            this.cage.m_104301_(pPoseStack, ACTIVE_SHELL_TEXTURE.m_119194_(pBuffer, RenderType::m_110458_), pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
            int i = pBlockEntity.tickCount / 66 % 3;
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, 0.5f, 0.5f);
            if (i == 1) {
                pPoseStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
            } else if (i == 2) {
                pPoseStack.m_252781_(new Quaternionf().rotationZ(1.5707964f));
            }
            VertexConsumer vertexconsumer = (i == 1 ? VERTICAL_WIND_TEXTURE : WIND_TEXTURE).m_119194_(pBuffer, RenderType::m_110458_);
            this.wind.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, 0.5f, 0.5f);
            pPoseStack.m_85841_(0.875f, 0.875f, 0.875f);
            pPoseStack.m_252781_(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
            this.wind.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
            Camera camera = this.renderer.f_112249_;
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            float f3 = -camera.m_90590_();
            pPoseStack.m_252781_(new Quaternionf().rotationYXZ(f3 * ((float)Math.PI / 180), camera.m_90589_() * ((float)Math.PI / 180), (float)Math.PI));
            float f4 = 1.3333334f;
            pPoseStack.m_85841_(1.3333334f, 1.3333334f, 1.3333334f);
            this.eye.m_104301_(pPoseStack, (pBlockEntity.isHunting() ? OPEN_EYE_TEXTURE : CLOSED_EYE_TEXTURE).m_119194_(pBuffer, RenderType::m_110458_), pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
        }
    }
}

