/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.gui.ObjectBaseContainer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class ItemBaseContainer
extends ObjectBaseContainer<ItemStack> {
    private final Supplier<ItemStack> stackSupplier;
    protected final Predicate<ItemStack> stackValidator;

    private ItemBaseContainer(BaseContainerType<?> type, Player player, Supplier<ItemStack> itemStackSupplier, Predicate<ItemStack> stackValidator) {
        super(type, player, true);
        this.stackSupplier = itemStackSupplier;
        this.stackValidator = stackValidator;
    }

    protected ItemBaseContainer(BaseContainerType<?> type, Player player, int playerSlot, Predicate<ItemStack> stackValidator) {
        this(type, player, () -> player.m_150109_().m_8020_(playerSlot), stackValidator);
    }

    protected ItemBaseContainer(BaseContainerType<?> type, Player player, InteractionHand hand, Predicate<ItemStack> stackValidator) {
        this(type, player, () -> ClientUtils.getPlayer().m_21120_(hand), stackValidator);
    }

    @Override
    protected ItemStack getObject(ItemStack oldObject) {
        return this.stackSupplier.get();
    }

    @Override
    protected boolean validateObject(ItemStack object) {
        return object != null && this.stackValidator.test(object);
    }
}

