/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.gui.impl.forge.ForgeNode;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.networking.forge.RequestConfigPacket;
import carbonconfiglib.networking.forge.SaveForgeConfigPacket;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.toml.TomlFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ForgeConfig
implements IModConfig {
    ModConfig config;
    ForgeConfigSpec spec;
    CommentedConfig data;
    List<ForgeConfigSpec.ConfigValue<?>> entries;
    Path path;

    public ForgeConfig(ModConfig config) {
        this.config = config;
        this.spec = this.getSpec(config.getSpec());
        this.data = config.getConfigData();
        this.entries = this.collect();
    }

    public ForgeConfig(ModConfig config, CommentedConfig data, Path path) {
        this.config = config;
        this.data = data;
        this.path = path;
        this.spec = this.getSpec(config.getSpec());
        this.entries = this.collect();
    }

    @Override
    public boolean canCreateConfigs() {
        return false;
    }

    @Override
    public boolean createConfig(Path path) {
        return false;
    }

    private ForgeConfigSpec getSpec(IConfigSpec<?> spec) {
        if (spec instanceof ForgeConfigSpec) {
            return (ForgeConfigSpec)spec;
        }
        try {
            Class<?> clz = Class.forName("fuzs.nightconfigfixes.config.ConfigSpecWrapper");
            if (clz == null) {
                return null;
            }
            if (!clz.isInstance(spec)) {
                return null;
            }
            Method method = clz.getMethod("getSpec", new Class[0]);
            method.setAccessible(true);
            return (ForgeConfigSpec)method.invoke(spec, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getConfigName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public boolean isDynamicConfig() {
        return this.config.getType() == ModConfig.Type.SERVER;
    }

    @Override
    public boolean isLocalConfig() {
        return this.path == null;
    }

    @Override
    public ConfigType getConfigType() {
        switch (this.config.getType()) {
            case CLIENT: {
                return ConfigType.CLIENT;
            }
            case COMMON: {
                return ConfigType.SHARED;
            }
            case SERVER: {
                return ConfigType.SERVER;
            }
        }
        throw new IllegalArgumentException("Type: " + this.config.getType() + ", not supported");
    }

    @Override
    public IConfigNode getRootNode() {
        return new ForgeNode((List<String>)new ObjectArrayList(), this.data, this.spec);
    }

    @Override
    public boolean isDefault() {
        if (this.data == null) {
            return true;
        }
        int m = this.entries.size();
        for (int i = 0; i < m; ++i) {
            ForgeConfigSpec.ConfigValue<?> entry = this.entries.get(i);
            if (Objects.equals(entry.getDefault(), this.data.get(entry.getPath()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreDefault() {
        if (this.data == null) {
            return;
        }
        int m = this.entries.size();
        for (int i = 0; i < m; ++i) {
            ForgeConfigSpec.ConfigValue<?> entry = this.entries.get(i);
            this.data.set(entry.getPath(), entry.getDefault());
        }
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        if (this.getConfigType() == ConfigType.SERVER) {
            return this.getLevels();
        }
        return ObjectLists.emptyList();
    }

    @Override
    public IModConfig loadFromFile(Path path) {
        try {
            return new ForgeConfig(this.config, (CommentedConfig)TomlFormat.instance().createParser().parse(path, FileNotFoundAction.THROW_ERROR), path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<FriendlyByteBuf>> network) {
        NetworkForgeConfig config = new NetworkForgeConfig(this.config);
        CarbonConfig.NETWORK.sendToServer(new RequestConfigPacket(this.config.getType(), requestId, this.config.getModId()));
        network.accept(config);
        return config;
    }

    @Override
    public void save() {
        if (this.path != null) {
            ForgeHelpers.saveConfig(this.path, this.data);
            return;
        }
        this.config.save();
        this.config.getSpec().afterReload();
        ((ModContainer)ModList.get().getModContainerById(this.config.getModId()).get()).dispatchConfigEvent((IConfigEvent)new ModConfigEvent.Reloading(this.config));
    }

    private List<ForgeConfigSpec.ConfigValue<?>> collect() {
        ObjectArrayList values = new ObjectArrayList();
        this.iterate(this.spec.getValues().valueMap().values(), ((List)values)::add);
        return values;
    }

    private void iterate(Iterable<Object> source, Consumer<ForgeConfigSpec.ConfigValue<?>> result) {
        for (Object entry : source) {
            if (entry instanceof ForgeConfigSpec.ConfigValue) {
                result.accept((ForgeConfigSpec.ConfigValue)entry);
                continue;
            }
            if (!(entry instanceof Config)) continue;
            this.iterate(((Config)entry).valueMap().values(), result);
        }
    }

    private List<IModConfig.IConfigTarget> getLevels() {
        LevelStorageSource storage = Minecraft.m_91087_().m_91392_();
        ObjectArrayList folders = new ObjectArrayList();
        for (LevelSummary sum : (List)storage.m_230813_(storage.m_230833_()).join()) {
            try {
                LevelStorageSource.LevelStorageAccess access = Minecraft.m_91087_().m_91392_().m_78260_(sum.m_78358_());
                try {
                    Path file;
                    Path path = access.m_78283_(PerWorldProxy.SERVERCONFIG);
                    if (Files.notExists(path, new LinkOption[0]) || Files.notExists(file = path.resolve(this.config.getFileName()), new LinkOption[0])) continue;
                    folders.add(new IModConfig.WorldConfigTarget(new PerWorldProxy.WorldTarget(sum, access.m_78283_(LevelResource.f_78182_), path), file));
                }
                finally {
                    if (access == null) continue;
                    access.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return folders;
    }

    public static class NetworkForgeConfig
    extends ForgeConfig
    implements Predicate<FriendlyByteBuf> {
        public NetworkForgeConfig(ModConfig config) {
            super(config, null, null);
        }

        @Override
        public boolean test(FriendlyByteBuf t) {
            try {
                this.data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(t.m_130052_()));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void save() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.data.configFormat().createWriter().write((UnmodifiableConfig)this.data, (OutputStream)stream);
            CarbonConfig.NETWORK.sendToServer(new SaveForgeConfigPacket(this.config.getType(), this.config.getModId(), stream.toByteArray()));
        }

        @Override
        public boolean isLocalConfig() {
            return false;
        }
    }
}

