/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.carbon.CarbonArray;
import carbonconfiglib.gui.impl.carbon.CarbonValue;
import carbonconfiglib.gui.impl.carbon.IValueActions;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureCompound;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.utils.Stack;

public class CarbonCompound
implements ICompoundNode,
IValueActions {
    IReloadMode mode;
    StructureCompound.CompoundData data;
    Component name;
    Component tooltip;
    Function<String, ParseResult<Boolean>> isValid;
    Supplier<List<ISuggestionProvider.Suggestion>> suggestions;
    BiConsumer<String, IValueActions> saveAction;
    Map<String, String> validationTemp = Object2ObjectMap.builder().linkedMap();
    List<IValueActions> values = new ObjectArrayList();
    Stack<Map<String, String>> previous = new ObjectArrayList();
    Map<String, String> current = Object2ObjectMap.builder().linkedMap();
    Map<String, String> defaultValue = Object2ObjectMap.builder().linkedMap();

    public CarbonCompound(IReloadMode mode, StructureCompound.CompoundData data, Component name, Component tooltip, String value, String defaultValue, Function<String, ParseResult<Boolean>> isValid, Supplier<List<ISuggestionProvider.Suggestion>> suggestions, BiConsumer<String, IValueActions> saveAction) {
        this.mode = mode;
        this.data = data;
        this.name = name;
        this.current.putAll(Helpers.splitArguments(Helpers.splitCompound(value), data.getKeys(), true));
        this.defaultValue.putAll(Helpers.splitArguments(Helpers.splitCompound(defaultValue), data.getKeys(), true));
        this.previous.push((Object)Object2ObjectMap.builder().linkedMap(this.current));
        this.tooltip = tooltip;
        this.isValid = isValid;
        this.suggestions = suggestions;
        this.saveAction = saveAction;
        this.reload();
    }

    private void reload() {
        this.values.clear();
        Map<String, IStructuredData> structure = this.data.getFormat();
        for (Map.Entry<String, String> entry : this.current.entrySet()) {
            String key = entry.getKey();
            this.values.add(this.addEntry(Helpers.removeLayer(entry.getValue(), 0), Helpers.removeLayer(this.defaultValue.getOrDefault(key, ""), 0), structure.get(key), key));
        }
    }

    protected IValueActions addEntry(String value, String defaultValue, IStructuredData type, String key) {
        switch (type.getDataType()) {
            case COMPOUND: {
                return new CarbonCompound(this.mode, type.asCompound(), (Component)IConfigNode.createLabel(key), this.createTooltip(key), value, defaultValue, T -> this.isValid(key, (String)T), () -> this.data.getSuggestions(key, this::isSuggestionValid), (T, V) -> this.save(key, (String)T));
            }
            case LIST: {
                return new CarbonArray(this.mode, type.asList(), (Component)IConfigNode.createLabel(key), this.createTooltip(key), value, defaultValue, T -> this.isValid(key, (String)T), () -> this.data.getSuggestions(key, this::isSuggestionValid), (T, V) -> this.save(key, (String)T));
            }
            case SIMPLE: {
                return new CarbonValue(this.mode, (Component)IConfigNode.createLabel(key), this.createTooltip(key), DataType.bySimple(type.asSimple()), this.data.isForcedSuggestion(key), () -> this.data.getSuggestions(key, this::isSuggestionValid), value, defaultValue, T -> this.isValid(key, (String)T), (T, V) -> this.save(key, (String)T));
            }
        }
        return null;
    }

    private Map<String, String> getPrev() {
        return (Map)this.previous.top();
    }

    protected void save(String key, String value) {
        this.current.put(key, value);
    }

    protected boolean isSuggestionValid(String key, String value) {
        return this.isValid(key, value).getValue();
    }

    protected ParseResult<Boolean> isValid(String key, String value) {
        this.validationTemp.clear();
        this.validationTemp.putAll(this.current);
        this.validationTemp.put(key, value);
        return this.isValid.apply(Helpers.mergeCompound(this.current, false, 0));
    }

    private Component createTooltip(String key) {
        MutableComponent comp = Component.m_237119_();
        comp.m_7220_((Component)Component.m_237113_((String)key).m_130940_(ChatFormatting.YELLOW));
        String[] array = this.data.getComments(key);
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.m_130946_("\n").m_130946_(array[i++]).m_130940_(ChatFormatting.GRAY);
            }
        }
        return comp;
    }

    @Override
    public void save() {
        this.saveAction.accept(Helpers.mergeCompound(this.current, false, 0), this);
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.defaultValue, this.current);
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.getPrev(), this.current);
    }

    @Override
    public void setDefault() {
        this.current.clear();
        this.current.putAll(this.defaultValue);
        this.reload();
    }

    @Override
    public void setPrevious() {
        this.current.clear();
        this.current.putAll(this.getPrev());
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        this.reload();
    }

    @Override
    public void createTemp() {
        this.previous.push((Object)Object2ObjectMap.builder().linkedMap(this.current));
        this.reload();
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        int m = this.values.size();
        for (int i = 0; i < m; ++i) {
            this.values.get(i).save();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid.apply(this.get()).getValue();
    }

    @Override
    public String get() {
        return Helpers.mergeCompound(this.current, false, 0);
    }

    @Override
    public void set(String value) {
        this.current.clear();
        this.current.putAll(Helpers.splitArguments(Helpers.splitCompound(value), this.data.getKeys(), true));
    }

    @Override
    public List<? extends INode> getValues() {
        return this.values;
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.COMPOUND;
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }
}

