/*
 * Decompiled with CFR 0.152.
 */
package com.pouffydev.tcompat.data.material;

import com.pouffydev.tcompat.data.builder.TComBaseRecipeProvider;
import com.pouffydev.tcompat.material.TComMaterialIds;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class TComMaterialRecipeProv
extends TComBaseRecipeProvider
implements IMaterialRecipeHelper {
    public TComMaterialRecipeProv(PackOutput generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(generator, lookupProvider);
    }

    @Override
    public String m_6055_() {
        return "Tinker's Compatability Material Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialItems(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        Consumer otbwgConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("biomeswevegone")});
        Consumer aetherConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aether")});
        Consumer deepAetherConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("deep_aether")});
        List<MaterialVariantId> noPlanks = List.of(TComMaterialIds.paloVerde);
        for (MaterialVariantId materialVariantId : TComMaterialIds.otbwgVariantWoods) {
            if (!noPlanks.contains(materialVariantId)) {
                this.planksVariantRecipe(otbwgConsumer, materialVariantId, "biomeswevegone");
            }
            this.logVariantRecipe(otbwgConsumer, materialVariantId, "biomeswevegone");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.otbwgVariantRocks) {
            this.rockVariantRecipe(otbwgConsumer, materialVariantId, "biomeswevegone");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.aetherVariantWoods) {
            if (!noPlanks.contains(materialVariantId)) {
                this.planksVariantRecipe(aetherConsumer, materialVariantId, "aether");
            }
            this.logVariantRecipe(aetherConsumer, materialVariantId, "aether");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.aetherVariantRocks) {
            this.rockVariantRecipe(aetherConsumer, materialVariantId, "aether");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.deepAetherVariantWoods) {
            if (!noPlanks.contains(materialVariantId)) {
                this.planksVariantRecipe(deepAetherConsumer, materialVariantId, "deep_aether");
            }
            this.logVariantRecipe(deepAetherConsumer, materialVariantId, "deep_aether");
        }
        for (MaterialVariantId materialVariantId : TComMaterialIds.deepAetherVariantRocks) {
            this.rockVariantRecipe(deepAetherConsumer, materialVariantId, "deep_aether");
        }
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
    }

    private void planksVariantRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String namespace) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, material, Ingredient.m_204132_(TComMaterialRecipeProv.itemTag("%s:%s_planks".formatted(namespace, material.getVariant()))), 1, 1, folder + "wood/planks/%s".formatted(material.getVariant()));
    }

    private void logVariantRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String namespace) {
        String folder = "tools/materials/";
        TagKey<Item> logs = TComMaterialRecipeProv.itemTag("%s:%s_logs".formatted(namespace, material.getVariant()));
        this.materialRecipe(consumer, material, Ingredient.m_204132_(logs), 4, 1, ItemOutput.fromTag(TComMaterialRecipeProv.itemTag("%s:%s_planks".formatted(namespace, material.getVariant()))), folder + "wood/logs/%s".formatted(material.getVariant()));
    }

    private void rockVariantRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String namespace) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, material, Ingredient.m_204132_(TComMaterialRecipeProv.itemTag("%s:%s".formatted(namespace, material.getVariant()))), 1, 1, folder + "rock/%s".formatted(material.getVariant()));
    }

    private static ResourceKey<Item> itemKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name));
    }

    private static TagKey<Item> itemTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name));
    }
}

