/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.discs;

public class NodPattern {
    private static final String VALID_NOD_TYPES = "_Xx";
    public static final char NOD_NONE = '_';
    public static final char NOD_NORMAL = 'X';
    public static final char NOD_SLIGHT = 'x';
    public static final NodPattern NONE = new NodPattern("_");
    public static final NodPattern NORMAL = new NodPattern("X");
    public static final NodPattern SLIGHT = new NodPattern("x");
    public static final NodPattern SLIGHT_NORMAL_ALTERNATING = new NodPattern("xX");
    public static final NodPattern NORMAL_SLIGHT_ALTERNATING = new NodPattern("Xx");
    public static final NodPattern DOWNBEAT8 = new NodPattern("Xxxxxxxx");
    public static final NodPattern DOWNBEAT4 = new NodPattern("Xxxx");
    public static final NodPattern DOWNBEAT3 = new NodPattern("Xxx");
    String pattern;

    public NodPattern(String pattern) {
        if (!NodPattern.isValidNodPattern(pattern)) {
            throw new IllegalArgumentException("Invalid nod pattern");
        }
        this.pattern = pattern;
    }

    public char getNodType(int beat) {
        return this.pattern.charAt(beat % this.pattern.length());
    }

    private static boolean isValidNodPattern(String pattern) {
        if (pattern.length() == 0) {
            return false;
        }
        for (char c : pattern.toCharArray()) {
            if (VALID_NOD_TYPES.contains(String.valueOf(c))) continue;
            return false;
        }
        return true;
    }
}

