/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.discs;

import com.shmove.cat_jam.discs.NodPattern;

public record DiscSegment(double bpm, int lengthInBeats, NodPattern nodPattern, double beatTickInterval) {
    public DiscSegment {
        if (bpm < 0.0) {
            throw new IllegalArgumentException("Segment BPM must be positive");
        }
        if (lengthInBeats <= 0 && lengthInBeats != -1) {
            throw new IllegalArgumentException("Segment length must be positive or -1 (infinite)");
        }
    }

    public DiscSegment(double bpm) {
        this(bpm, -1, NodPattern.NORMAL);
    }

    public DiscSegment(double bpm, int lengthInBeats) {
        this(bpm, lengthInBeats, NodPattern.NORMAL);
    }

    public DiscSegment(double bpm, int lengthInBeats, NodPattern nodPattern) {
        this(bpm, lengthInBeats, nodPattern, DiscSegment.getBeatTickInterval(bpm));
    }

    private static double getBeatTickInterval(double bpm) {
        double TICKS_IN_ONE_MINUTE = 1200.0;
        if (bpm == 0.0) {
            return -1.0;
        }
        return 1200.0 / bpm;
    }
}

