/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.behaviour;

import com.shmove.cat_jam.access.JammingEntity;
import com.shmove.cat_jam.cat_jam;
import com.shmove.cat_jam.discs.DiscPlayback;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class JammingState {
    private final LivingEntity jammingEntity;
    private BlockPos musicSourceBlock = null;
    private Integer musicSourceEntityID = null;
    private boolean catJamming = false;
    private DiscPlayback discPlayback = null;
    private int nodTick = -1;
    private int slightNodTick = -1;

    public JammingState(LivingEntity jammingEntity) {
        this.jammingEntity = jammingEntity;
    }

    public void tick() {
        Entity musicSourceEntity;
        if (!this.jammingEntity.m_9236_().f_46443_) {
            return;
        }
        if (!(this.musicSourceBlock == null || this.musicSourceBlock.m_203195_((Position)this.jammingEntity.m_20182_(), 3.46) && cat_jam.isSourcePlayingAtPos(this.musicSourceBlock))) {
            this.resetJammingInfo();
        }
        if (!(this.musicSourceEntityID == null || (musicSourceEntity = this.jammingEntity.m_9236_().m_6815_(this.musicSourceEntityID.intValue())) != null && musicSourceEntity.m_19950_((Entity)this.jammingEntity, 3.46) && musicSourceEntity.m_6084_() && cat_jam.isSourcePlayingFromEntity(this.musicSourceEntityID))) {
            this.resetJammingInfo();
        }
        if (!this.catJamming) {
            this.findNewMusicSource();
        }
        if (this.catJamming) {
            this.updateNod();
            this.updateNodAnim();
        }
    }

    public void resetJammingInfo() {
        this.musicSourceBlock = null;
        this.musicSourceEntityID = null;
        this.discPlayback = null;
        this.catJamming = false;
        this.nodTick = -1;
        this.slightNodTick = -1;
    }

    public int getNodTick() {
        return this.nodTick;
    }

    public int getSlightNodTick() {
        return this.slightNodTick;
    }

    public void updateMusicSource(BlockPos sourcePos) {
        if (!((JammingEntity)this.jammingEntity).cat_jam$isInValidStateToJam()) {
            return;
        }
        this.musicSourceBlock = sourcePos;
        this.discPlayback = cat_jam.getDiscPlaybackAtPos(sourcePos);
        this.catJamming = true;
        this.jammingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.jammingEntity.m_20185_(), this.jammingEntity.m_20186_() + 0.3, this.jammingEntity.m_20189_(), 0.0, 0.0, 0.0);
    }

    public void updateMusicSource(Integer sourceEntityID) {
        if (!((JammingEntity)this.jammingEntity).cat_jam$isInValidStateToJam()) {
            return;
        }
        this.musicSourceEntityID = sourceEntityID;
        this.discPlayback = cat_jam.getDiscPlaybackFromEntity(sourceEntityID);
        this.catJamming = true;
        this.jammingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.jammingEntity.m_20185_(), this.jammingEntity.m_20186_() + 0.3, this.jammingEntity.m_20189_(), 0.0, 0.0, 0.0);
    }

    private void findNewMusicSource() {
        boolean FOUND_ENTITY_SOURCE;
        BlockPos nearbyBlockSource = cat_jam.getClosestListenableSourcePos(this.jammingEntity.m_20182_());
        Entity nearbyEntitySource = cat_jam.getClosestListenableSourceEntity(this.jammingEntity.m_20182_());
        boolean FOUND_BLOCK_SOURCE = nearbyBlockSource != null;
        boolean bl = FOUND_ENTITY_SOURCE = nearbyEntitySource != null;
        if (!FOUND_BLOCK_SOURCE && !FOUND_ENTITY_SOURCE) {
            return;
        }
        if (FOUND_BLOCK_SOURCE && FOUND_ENTITY_SOURCE) {
            double entityDist;
            double blockDist = nearbyBlockSource.m_203193_((Position)this.jammingEntity.m_20182_());
            if (blockDist < (entityDist = nearbyEntitySource.m_20280_((Entity)this.jammingEntity))) {
                this.updateMusicSource(nearbyBlockSource);
            } else {
                this.updateMusicSource(nearbyEntitySource.m_19879_());
            }
        } else if (FOUND_BLOCK_SOURCE) {
            this.updateMusicSource(nearbyBlockSource);
        } else if (FOUND_ENTITY_SOURCE) {
            this.updateMusicSource(nearbyEntitySource.m_19879_());
        }
    }

    private void updateNod() {
        int nodPreempt = 2;
        boolean slightNodPreempt = true;
        if (this.discPlayback.anticipateBeat(2) && this.discPlayback.isNodBeat()) {
            if (this.nodTick >= 0 && this.nodTick <= 2) {
                return;
            }
            this.nodTick = 0;
        } else if (this.discPlayback.anticipateBeat(1) && this.discPlayback.isSlightNodBeat()) {
            if (this.slightNodTick >= 0 && this.slightNodTick <= 1) {
                return;
            }
            this.slightNodTick = 0;
        }
    }

    private void updateNodAnim() {
        int nodAnimTickLength = 8;
        int slightNodAnimTickLength = 6;
        if (this.nodTick >= 0) {
            if (this.nodTick < 7) {
                ++this.nodTick;
            } else if (this.nodTick == 7) {
                this.nodTick = -1;
            }
        }
        if (this.slightNodTick >= 0) {
            if (this.slightNodTick < 5) {
                ++this.slightNodTick;
            } else if (this.slightNodTick == 5) {
                this.slightNodTick = -1;
            }
        }
    }
}

