/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.components;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public record RenderInfo(CompoundTag compoundTag) {
    public static final RenderInfo EMPTY = new RenderInfo(new CompoundTag());

    public boolean isEmpty() {
        return this.compoundTag.m_128456_();
    }

    public boolean hasTanks() {
        return this.compoundTag.m_128441_("LeftTank") || this.compoundTag.m_128441_("RightTank");
    }

    public FluidStack getLeftFluidStack() {
        if (this.compoundTag.m_128441_("LeftTank")) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)this.compoundTag.m_128469_("LeftTank"));
        }
        return FluidStack.EMPTY;
    }

    public FluidStack getRightFluidStack() {
        if (this.compoundTag.m_128441_("RightTank")) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)this.compoundTag.m_128469_("RightTank"));
        }
        return FluidStack.EMPTY;
    }

    public void updateCapacity(int capacity) {
        if (this.compoundTag.m_128441_("Capacity")) {
            this.compoundTag.m_128405_("Capacity", capacity);
        }
    }

    public int getCapacity() {
        if (this.compoundTag.m_128441_("Capacity")) {
            return this.compoundTag.m_128451_("Capacity");
        }
        return 0;
    }

    public static RenderInfo createCreativeTabInfo() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("LeftTank", (Tag)new FluidStack((Fluid)Fluids.f_76193_, 1).writeToNBT(new CompoundTag()));
        tag.m_128365_("RightTank", (Tag)new FluidStack((Fluid)Fluids.f_76195_, 1).writeToNBT(new CompoundTag()));
        tag.m_128405_("Capacity", 1);
        return new RenderInfo(tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof RenderInfo)) return false;
        RenderInfo renderInfo = (RenderInfo)pOther;
        if (!this.compoundTag.toString().equals(renderInfo.compoundTag.toString())) return false;
        return true;
    }
}

