/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PaintingListMessage
extends Message {
    private final Map<String, CompoundTag> paintings = new HashMap<String, CompoundTag>();
    private final boolean clear;

    public PaintingListMessage() {
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.getDatapackPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.get().getCustomServerPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        this.clear = true;
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.paintings.size());
        for (Map.Entry<String, CompoundTag> entry : this.paintings.entrySet()) {
            b.m_130070_(entry.getKey());
            b.m_130079_(entry.getValue());
        }
        b.writeBoolean(this.clear);
    }

    public PaintingListMessage(FriendlyByteBuf b) {
        int size = b.readInt();
        for (int i = 0; i < size; ++i) {
            String key = b.m_130277_();
            CompoundTag value = b.m_130260_();
            this.paintings.put(key, value);
        }
        this.clear = b.readBoolean();
    }

    public PaintingListMessage(ResourceLocation identifier, Painting painting) {
        this.paintings.put(identifier.toString(), painting == null ? null : painting.toNbt());
        this.clear = false;
    }

    @Override
    public void receive(Player e) {
        Main.networkManager.handlePaintingListResponse(this);
    }

    public Map<ResourceLocation, Painting> getPaintings() {
        HashMap<ResourceLocation, Painting> paintings = new HashMap<ResourceLocation, Painting>();
        for (Map.Entry<String, CompoundTag> entry : this.paintings.entrySet()) {
            ResourceLocation identifier = new ResourceLocation(entry.getKey());
            if (entry.getValue() == null) {
                paintings.put(identifier, null);
                continue;
            }
            paintings.put(identifier, Painting.fromNbt(entry.getValue()));
        }
        return paintings;
    }

    public boolean shouldClear() {
        return this.clear;
    }
}

