/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import twilightforest.TwilightForestMod;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.util.MagicPaintingVariant;

public class MagicPaintingVariants {
    public static final ResourceKey<Registry<MagicPaintingVariant>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)TwilightForestMod.namedRegistry("magic_paintings"));
    public static final DeferredRegister<MagicPaintingVariant> MAGIC_PAINTINGS = DeferredRegister.create(REGISTRY_KEY, (String)"twilightforest");
    public static final Codec<Holder<MagicPaintingVariant>> CODEC = RegistryFileCodec.m_135592_(REGISTRY_KEY, MagicPaintingVariant.CODEC, (boolean)false);
    public static final ResourceKey<MagicPaintingVariant> DARKNESS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("darkness"));
    public static final ResourceKey<MagicPaintingVariant> LUCID_LANDS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("lucid_lands"));

    private static ResourceKey<MagicPaintingVariant> makeKey(ResourceLocation name) {
        return ResourceKey.m_135785_(REGISTRY_KEY, (ResourceLocation)name);
    }

    public static void bootstrap(BootstapContext<MagicPaintingVariant> context) {
        MagicPaintingVariants.register(context, DARKNESS, "Darkness", "???", 64, 32, List.of(new MagicPaintingVariant.Layer("background", null, null, true), new MagicPaintingVariant.Layer("sky", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.01f, 128, 32), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.SINE_TIME, 0.03f, false), true), new MagicPaintingVariant.Layer("terrain", null, null, false), new MagicPaintingVariant.Layer("gems", null, null, true), new MagicPaintingVariant.Layer("gems", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DAY_TIME, 2.0f, true), true), new MagicPaintingVariant.Layer("lightning", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 1.0f, false), true)));
        MagicPaintingVariants.register(context, LUCID_LANDS, "Lucid Lands", "Androsa", 32, 32, List.of(new MagicPaintingVariant.Layer("background", null, null, true), new MagicPaintingVariant.Layer("clouds", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.SINE_TIME, 0.01f, 48, 32), null, true), new MagicPaintingVariant.Layer("volcanic_lands", null, null, true), new MagicPaintingVariant.Layer("agate_jungle", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 44, 32), null, true), new MagicPaintingVariant.Layer("crystal_plains", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.025f, 58, 32), null, true)));
    }

    public static void register(BootstapContext<MagicPaintingVariant> context, ResourceKey<MagicPaintingVariant> key, String title, String author, int width, int height, List<MagicPaintingVariant.Layer> layers) {
        MagicPaintingVariant variant = new MagicPaintingVariant(width, height, layers);
        AtlasGenerator.MAGIC_PAINTING_HELPER.put(key.m_135782_(), variant);
        LangGenerator.MAGIC_PAINTING_HELPER.put(key.m_135782_(), (Pair<String, String>)Pair.of((Object)title, (Object)author));
        context.m_255272_(key, (Object)variant);
    }

    public static Optional<MagicPaintingVariant> getVariant(RegistryAccess regAccess, String id) {
        return MagicPaintingVariants.getVariant(regAccess, new ResourceLocation(id));
    }

    public static Optional<MagicPaintingVariant> getVariant(RegistryAccess regAccess, ResourceLocation id) {
        return regAccess.m_6632_(REGISTRY_KEY).map(reg -> (MagicPaintingVariant)reg.m_7745_(id));
    }

    public static String getVariantId(RegistryAccess regAccess, MagicPaintingVariant variant) {
        return MagicPaintingVariants.getVariantResourceLocation(regAccess, variant).toString();
    }

    public static ResourceLocation getVariantResourceLocation(RegistryAccess regAccess, MagicPaintingVariant variant) {
        return regAccess.m_6632_(REGISTRY_KEY).map(reg -> reg.m_7981_((Object)variant)).orElse(new ResourceLocation("null"));
    }
}

