/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.capabilities.CapabilityList;
import twilightforest.entity.boss.Lich;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EffectRenders {
    SHIELDS{

        @Override
        public boolean shouldRender(LivingEntity entity, boolean firstPerson) {
            if (entity instanceof Lich) {
                return false;
            }
            return entity.getCapability(CapabilityList.SHIELDS).map(c -> c.shieldsLeft() > 0).orElse(false);
        }

        @Override
        public void render(LivingEntity entity, EntityModel<? extends LivingEntity> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
            PoseStack ms = RenderSystem.getModelViewStack();
            ms.m_85836_();
            ms.m_85837_(x, y, z);
            ms.m_252880_(0.0f, 0.5f - entity.m_20192_(), 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            ms.m_85849_();
        }
    };

    static final EffectRenders[] VALUES;

    public boolean shouldRender(LivingEntity entity, boolean firstPerson) {
        return false;
    }

    public void render(LivingEntity entity, EntityModel<? extends LivingEntity> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
    }

    static {
        VALUES = EffectRenders.values();
    }
}

