/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TrophyBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.PlayerHelper;

public class TrophyPedestalBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BOTTOM = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape MID = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final VoxelShape TOP = Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CORNER1 = Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
    private static final VoxelShape CORNER2 = Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
    private static final VoxelShape CORNER3 = Block.m_49796_((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
    private static final VoxelShape CORNER4 = Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
    private static final VoxelShape FINAL = Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{MID, TOP, CORNER1, CORNER2, CORNER3, CORNER4});

    public TrophyPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE, WATERLOGGED});
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return FINAL;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        level.m_46717_(pos, (Block)this);
        if (level.m_5776_() || ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() || !this.isTrophyOnTop(level, pos)) {
            return;
        }
        if (LandmarkUtil.isProgressionEnforced(level)) {
            if (this.areNearbyPlayersEligible(level, pos)) {
                this.doPedestalEffect(level, pos, state);
            }
            this.warnIneligiblePlayers(level, pos);
        } else {
            this.doPedestalEffect(level, pos, state);
        }
        this.rewardNearbyPlayers(level, pos);
    }

    private boolean isTrophyOnTop(Level level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_204336_(BlockTagGenerator.TROPHIES);
    }

    private void warnIneligiblePlayers(Level level, BlockPos pos) {
        for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
            if (this.isPlayerEligible(player)) continue;
            player.m_5661_((Component)Component.m_237115_((String)"misc.twilightforest.pedestal_ineligible"), true);
        }
    }

    private boolean areNearbyPlayersEligible(Level level, BlockPos pos) {
        for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
            if (!this.isPlayerEligible(player)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerEligible(Player player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, TwilightForestMod.prefix("progress_lich"));
    }

    private void doPedestalEffect(Level level, BlockPos pos, BlockState state) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.removeNearbyShields(level, pos);
        level.m_5594_(null, pos, (SoundEvent)TFSounds.PEDESTAL_ACTIVATE.get(), SoundSource.BLOCKS, 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(Level level, BlockPos pos) {
        for (ServerPlayer player : level.m_45976_(ServerPlayer.class, new AABB(pos).m_82400_(16.0))) {
            TFAdvancements.PLACED_TROPHY_ON_PEDESTAL.trigger(player);
            player.m_36220_((ResourceLocation)TFStats.TROPHY_PEDESTALS_ACTIVATED.get());
        }
    }

    private void removeNearbyShields(Level level, BlockPos pos) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    if (level.m_8055_(pos.m_7918_(sx, sy, sz)).m_60734_() != TFBlocks.STRONGHOLD_SHIELD.get()) continue;
                    level.m_46961_(pos.m_7918_(sx, sy, sz), false);
                }
            }
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? super.m_5880_(state, player, getter, pos) : -1.0f;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        Block trophy = level.m_8055_(pos.m_7494_()).m_60734_();
        if (trophy instanceof TrophyBlock) {
            TrophyBlock value = (TrophyBlock)trophy;
            return value.getComparatorValue();
        }
        return 0;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? PushReaction.NORMAL : PushReaction.BLOCK;
    }
}

