/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.codec.CodecExtensions;
import dev.compactmods.machines.api.codec.NbtListCollector;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.naming.OperationNotSupportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CompactRoomData
extends SavedData {
    public static final String DATA_NAME = "compactmachines_rooms";
    private final Map<ChunkPos, RoomData> roomData = new HashMap<ChunkPos, RoomData>();

    @Nonnull
    public static CompactRoomData get(ServerLevel compactDim) {
        DimensionDataStorage sd = compactDim.m_8895_();
        return (CompactRoomData)sd.m_164861_(CompactRoomData::fromNbt, CompactRoomData::new, DATA_NAME);
    }

    public static CompactRoomData fromNbt(CompoundTag nbt) {
        CompactRoomData data = new CompactRoomData();
        if (nbt.m_128441_("machines")) {
            ListTag machines = nbt.m_128437_("machines", 10);
            machines.forEach(machNbt -> {
                DataResult result = RoomData.CODEC.parse((DynamicOps)NbtOps.f_128958_, machNbt);
                result.resultOrPartial(err -> CompactMachines.LOGGER.error("Error loading machine data from file: {}", err)).ifPresent(imd -> {
                    ChunkPos chunk = new ChunkPos(imd.getCenter());
                    data.roomData.put(chunk, (RoomData)imd);
                });
            });
        }
        return data;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        if (!this.roomData.isEmpty()) {
            ListTag collect = this.roomData.values().stream().map(data -> {
                DataResult n = RoomData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, data);
                return n.result();
            }).filter(Optional::isPresent).map(Optional::get).collect(NbtListCollector.toNbtList());
            nbt.m_128365_("machines", (Tag)collect);
        }
        return nbt;
    }

    public Stream<ChunkPos> stream() {
        return this.roomData.keySet().stream();
    }

    public boolean isRegistered(ChunkPos chunkPos) {
        return this.roomData.containsKey(chunkPos);
    }

    private void register(ChunkPos pos, RoomData data) throws OperationNotSupportedException {
        if (this.isRegistered(pos)) {
            throw new OperationNotSupportedException("Machine already registered.");
        }
        this.roomData.put(pos, data);
        this.m_77762_();
    }

    public Optional<RoomData> forRoom(ChunkPos room) {
        if (this.roomData.containsKey(room)) {
            return Optional.ofNullable(this.roomData.get(room));
        }
        return Optional.empty();
    }

    public Stream<RoomData> streamRooms() {
        return this.roomData.values().stream();
    }

    @javax.annotation.Nullable
    public LevelBlockPosition getSpawn(ChunkPos roomChunk) {
        RoomData roomData = this.roomData.get(roomChunk);
        if (roomData == null) {
            return null;
        }
        return new LevelBlockPosition(CompactDimension.LEVEL_KEY, roomData.getSpawn(), roomData.getSpawnRotation());
    }

    public int getNextSpiralPosition() {
        return this.roomData.size() + 1;
    }

    @Deprecated
    public void setSpawn(ChunkPos roomChunk, Vec3 position) {
        this.setSpawn(roomChunk, position, Vec2.f_82462_);
    }

    public void setSpawn(ChunkPos roomChunk, Vec3 position, Vec2 rotation) {
        if (!this.roomData.containsKey(roomChunk)) {
            return;
        }
        RoomData roomData = this.roomData.get(roomChunk);
        roomData.setSpawn(position, rotation);
        this.m_77762_();
    }

    public AABB getBounds(ChunkPos roomChunk) throws NonexistentRoomException {
        if (!this.roomData.containsKey(roomChunk)) {
            throw new NonexistentRoomException(roomChunk);
        }
        return this.roomData.get(roomChunk).getRoomBounds();
    }

    public NewRoomRegistration createNew() {
        return new NewRoomRegistration(this);
    }

    public boolean isMachineRoomChunk(ChunkPos pos) {
        return this.roomData.containsKey(pos);
    }

    public void remove(ChunkPos room) {
        this.roomData.remove(room);
        this.m_77762_();
    }

    public RoomData getData(ChunkPos room) throws NonexistentRoomException {
        if (!this.roomData.containsKey(room)) {
            throw new NonexistentRoomException(room);
        }
        return this.roomData.get(room);
    }

    public static class RoomData {
        public static final Codec<RoomData> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.UUID_CODEC.fieldOf("owner").forGetter(RoomData::getOwner), (App)BlockPos.f_121852_.fieldOf("center").forGetter(RoomData::getCenter), (App)CodecExtensions.VECTOR3D.fieldOf("spawn").forGetter(RoomData::getSpawn), (App)CodecExtensions.VECTOR2.optionalFieldOf("spawnRot", (Object)Vec2.f_82462_).forGetter(RoomData::getSpawnRotation), (App)RoomSize.CODEC.fieldOf("size").forGetter(RoomData::getSize), (App)Codec.STRING.optionalFieldOf("name").forGetter(RoomData::getName)).apply((Applicative)i, RoomData::new));
        private final UUID owner;
        private final BlockPos center;
        private Vec3 spawn;
        @Nullable
        private Vec2 spawnRotation;
        private final RoomSize size;
        private boolean hasCustomName;
        private String name;

        public RoomData(UUID owner, BlockPos center, Vec3 spawn, Vec2 spawnRotation, RoomSize size, Optional<String> name) {
            this.owner = owner;
            this.center = center;
            this.spawn = spawn;
            this.spawnRotation = spawnRotation;
            this.size = size;
            name.ifPresentOrElse(n -> {
                this.name = n;
                this.hasCustomName = true;
            }, () -> {
                this.hasCustomName = false;
            });
        }

        public RoomSize getSize() {
            return this.size;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public Vec3 getSpawn() {
            if (this.spawn != null) {
                return this.spawn;
            }
            Vec3 newSpawn = new Vec3((double)this.center.m_123341_(), (double)this.center.m_123342_(), (double)this.center.m_123343_());
            double offset = (double)this.size.getInternalSize() / 2.0;
            this.spawn = newSpawn.m_82492_(0.0, offset, 0.0);
            return this.spawn;
        }

        public Vec2 getSpawnRotation() {
            return this.spawnRotation;
        }

        public BlockPos getCenter() {
            return this.center;
        }

        @Deprecated(forRemoval=true)
        public void setSpawn(Vec3 newSpawn) {
            this.setSpawn(newSpawn, Vec2.f_82462_);
        }

        public void setSpawn(Vec3 newSpawn, Vec2 rotation) {
            this.spawn = newSpawn;
            this.spawnRotation = rotation;
        }

        public AABB getRoomBounds() {
            return this.size.getBounds(this.center);
        }

        public boolean hasName() {
            return this.hasCustomName;
        }

        public void setName(String newName) {
            this.hasCustomName = true;
            this.name = newName;
        }

        public Optional<String> getName() {
            return this.hasCustomName ? Optional.ofNullable(this.name) : Optional.empty();
        }
    }

    public static class NewRoomRegistration {
        private final CompactRoomData storage;
        private Vec3 spawn;
        private ChunkPos chunk = new ChunkPos(0, 0);
        private RoomSize size = RoomSize.TINY;
        private BlockPos center = BlockPos.f_121853_;
        private UUID owner;

        public NewRoomRegistration(CompactRoomData storage) {
            this.storage = storage;
        }

        private void recalculateSize() {
            BlockPos centerAtFloor = MathUtil.getCenterWithY(this.chunk, (int)((Integer)ServerConfig.MACHINE_FLOOR_Y.get()));
            BlockPos centerSized = centerAtFloor.m_6630_(this.size.getInternalSize() / 2);
            this.spawn = new Vec3((double)centerAtFloor.m_123341_(), (double)(centerAtFloor.m_123342_() + 2), (double)centerAtFloor.m_123343_());
            this.center = centerSized;
        }

        public NewRoomRegistration owner(UUID owner) {
            this.owner = owner;
            return this;
        }

        public NewRoomRegistration size(RoomSize size) {
            this.size = size;
            this.recalculateSize();
            return this;
        }

        public NewRoomRegistration spawn(BlockPos spawn) {
            Vec3 spawnTest = new Vec3((double)spawn.m_123341_(), (double)spawn.m_123342_(), (double)spawn.m_123343_());
            if (this.size.getBounds(this.center).m_82390_(spawnTest)) {
                this.spawn = spawnTest;
            }
            return this;
        }

        public NewRoomRegistration chunk(ChunkPos chunk) {
            this.chunk = chunk;
            this.recalculateSize();
            return this;
        }

        public void register() throws OperationNotSupportedException {
            RoomData data = new RoomData(this.owner, this.center, this.spawn, Vec2.f_82462_, this.size, Optional.empty());
            this.storage.register(this.chunk, data);
        }
    }
}

