/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.api.room;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.AABB;

public enum RoomSize implements StringRepresentable
{
    TINY("tiny", 3),
    SMALL("small", 5),
    NORMAL("normal", 7),
    LARGE("large", 9),
    GIANT("giant", 11),
    MAXIMUM("maximum", 13);

    private final String name;
    private final int internalSize;
    public static final Codec<RoomSize> CODEC;

    private RoomSize(String name, int internalSize) {
        this.name = name;
        this.internalSize = internalSize;
    }

    public static RoomSize maximum() {
        return MAXIMUM;
    }

    public String getName() {
        return this.name;
    }

    public AABB getBounds(BlockPos center) {
        AABB bounds = new AABB(center);
        return bounds.m_82400_((double)Math.floorDiv(this.internalSize, 2));
    }

    public int getInternalSize() {
        return this.internalSize;
    }

    public static RoomSize getFromSize(String size) {
        switch (size.toLowerCase()) {
            case "tiny": {
                return TINY;
            }
            case "small": {
                return SMALL;
            }
            case "normal": {
                return NORMAL;
            }
            case "large": {
                return LARGE;
            }
            case "giant": {
                return GIANT;
            }
            case "maximum": {
                return MAXIMUM;
            }
        }
        return TINY;
    }

    public String m_7912_() {
        return this.name;
    }

    public Vec3i toVec3() {
        return new Vec3i(this.internalSize, this.internalSize, this.internalSize);
    }

    static {
        CODEC = StringRepresentable.m_216439_(RoomSize::values);
    }
}

