/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.pathfinder;

import net.minecraft.world.level.pathfinder.BlockPathTypes;

public enum ExtendedPathNodeType {
    BLOCKED(-1.0f),
    OPEN(0.0f),
    WALKABLE(0.0f),
    WALKABLE_DOOR(0.0f),
    TRAPDOOR(0.0f),
    POWDER_SNOW(-1.0f),
    DANGER_POWDER_SNOW(0.0f),
    FENCE(-1.0f),
    LAVA(-1.0f),
    WATER(8.0f),
    WATER_BORDER(8.0f),
    RAIL(0.0f),
    UNPASSABLE_RAIL(-1.0f),
    DANGER_FIRE(8.0f),
    DAMAGE_FIRE(16.0f),
    DANGER_OTHER(8.0f),
    DAMAGE_OTHER(-1.0f),
    DOOR_OPEN(0.0f),
    DOOR_WOOD_CLOSED(-1.0f),
    DOOR_IRON_CLOSED(-1.0f),
    BREACH(4.0f),
    LEAVES(-1.0f),
    STICKY_HONEY(8.0f),
    COCOA(0.0f),
    GRASS(-1.0f, BlockPathTypes.BLOCKED),
    PATH(-1.0f, BlockPathTypes.BLOCKED),
    WALKABLE_GRASS(0.0f, BlockPathTypes.WALKABLE),
    WALKABLE_PATH(0.0f, BlockPathTypes.WALKABLE);

    private final float defaultPenalty;
    private BlockPathTypes vanilla;

    private ExtendedPathNodeType(float defaultPenalty) {
        this(defaultPenalty, null);
        if (this.vanilla == null) {
            this.vanilla = BlockPathTypes.valueOf((String)this.name());
        }
    }

    private ExtendedPathNodeType(float defaultPenalty, BlockPathTypes vanilla) {
        this.defaultPenalty = defaultPenalty;
        this.vanilla = vanilla;
    }

    public float getDefaultPenalty() {
        return this.defaultPenalty;
    }

    public BlockPathTypes toVanilla() {
        return this.vanilla;
    }

    public boolean isWalkable() {
        return this == WALKABLE || this == WALKABLE_GRASS || this == WALKABLE_PATH;
    }

    public float getBonusPenalty() {
        return this.defaultPenalty >= 0.0f ? (this == WALKABLE_GRASS ? 2.0f : (this == WALKABLE_PATH ? 0.001f : (this == OPEN ? 0.0f : 1.0f))) : 0.0f;
    }
}

