/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.tts;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.client.tts.ElevenlabsSpeechManager;
import forge.net.mca.client.tts.OnlineSpeechManager;
import forge.net.mca.client.tts.Player2SpeechManager;
import forge.net.mca.client.tts.RealtimeSpeechManager;
import forge.net.mca.client.tts.sound.CustomEntityBoundSoundInstance;
import forge.net.mca.client.tts.sound.SingleWeighedSoundEvents;
import forge.net.mca.entity.CommonSpeechManager;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraft.world.entity.Entity;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    private final Minecraft client;
    private final LimitedLinkedHashMap<UUID, EntityBoundSoundInstance> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final RealtimeSpeechManager realtimeSpeechManager;
    private final Player2SpeechManager player2SpeechManager;
    private final ElevenlabsSpeechManager elevenlabsSpeechManager;
    private final OnlineSpeechManager onlineSpeechManager;
    private final RandomSource threadSafeRandom;
    private long lastHealthCheckTime;
    private boolean firstRun;

    public SpeechManager() {
        this.realtimeSpeechManager = new RealtimeSpeechManager(Config.getInstance().onlineTTSServer);
        this.player2SpeechManager = new Player2SpeechManager(Config.getInstance().player2Url);
        this.elevenlabsSpeechManager = new ElevenlabsSpeechManager();
        this.onlineSpeechManager = new OnlineSpeechManager();
        this.threadSafeRandom = RandomSource.m_216337_();
        this.lastHealthCheckTime = 0L;
        this.firstRun = true;
        this.client = Minecraft.m_91087_();
    }

    public EntityBoundSoundInstance getSound(float pitch, Entity entity, ResourceLocation soundLocation) {
        Sound sound = new Sound(soundLocation.m_135815_(), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), 1, Sound.Type.FILE, true, false, 16);
        SingleWeighedSoundEvents weightedSoundEvents = new SingleWeighedSoundEvents(sound, soundLocation, "");
        return new CustomEntityBoundSoundInstance(weightedSoundEvents, SoundEvent.m_262824_((ResourceLocation)soundLocation), SoundSource.NEUTRAL, 1.0f, pitch, entity, this.threadSafeRandom.m_188505_());
    }

    public void playSound(float pitch, Entity entity, ResourceLocation soundLocation) {
        this.client.execute(() -> this.client.m_91106_().m_120367_((SoundInstance)INSTANCE.getSound(pitch, entity, soundLocation)));
    }

    public void onChatMessage(Component message, UUID sender) {
        ComponentContents content = message.m_214077_();
        if (CommonSpeechManager.INSTANCE.translations.containsKey(content)) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(content), sender, true);
        } else if (content instanceof LiteralContents) {
            LiteralContents literal = (LiteralContents)content;
            this.speak(literal.f_237368_(), sender, false);
        }
    }

    private VillagerEntityMCA getSpeaker(Minecraft client, UUID sender) {
        if (client.f_91073_ != null) {
            for (Entity entity : client.f_91073_.m_104735_()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.m_20148_().equals(sender)) continue;
                return v;
            }
        }
        return null;
    }

    private void speak(String phrase, UUID sender, boolean translatable) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        if (this.currentlyPlaying.containsKey(sender) && client.m_91106_().m_120403_((SoundInstance)this.currentlyPlaying.get(sender))) {
            return;
        }
        VillagerEntityMCA villager = this.getSpeaker(client, sender);
        if (villager == null) {
            return;
        }
        if (villager.isSpeechImpaired()) {
            return;
        }
        if (villager.isToYoungToSpeak()) {
            return;
        }
        float pitch = villager.m_6100_();
        float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
        String gender = villager.getGenetics().getGender().binary().getDataName();
        if (Config.getInstance().enableOnlineTTS) {
            if (translatable) {
                if (Language.m_128107_().m_6722_(phrase)) {
                    phrase = Language.m_128107_().m_6834_(phrase);
                } else {
                    MCA.LOGGER.warn("Tried to play a TTS sound for a non-translatable phrase: {}", (Object)phrase);
                    return;
                }
            }
            String gameLang = client.f_91066_.f_92075_;
            switch (Config.getInstance().onlineTTSModel) {
                case "realtime": {
                    this.realtimeSpeechManager.play(phrase, gender, gameLang, pitch, gene, (Entity)villager, translatable);
                    break;
                }
                case "player2": {
                    this.player2SpeechManager.play(phrase, gender, gameLang, pitch, gene);
                    break;
                }
                case "elevenlabs": {
                    this.elevenlabsSpeechManager.play(phrase, gender, pitch, gene, (Entity)villager, translatable);
                    break;
                }
                default: {
                    this.onlineSpeechManager.play(phrase, gameLang, gender, pitch, gene, (Entity)villager, translatable);
                    break;
                }
            }
        } else if (translatable) {
            Collection keys;
            int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
            ResourceLocation sound = new ResourceLocation("mca_voices", phrase.toLowerCase(Locale.ROOT) + "/" + gender + "_" + tone);
            if (client.f_91073_ != null && client.f_91074_ != null && (keys = client.m_91106_().m_120354_()).contains(sound)) {
                EntityBoundSoundInstance instance = new EntityBoundSoundInstance(SoundEvent.m_262824_((ResourceLocation)sound), SoundSource.NEUTRAL, 1.0f, pitch, (Entity)villager, this.threadSafeRandom.m_188505_());
                this.currentlyPlaying.put(sender, instance);
                client.m_91106_().m_120367_((SoundInstance)instance);
            }
        }
    }

    public void tick(Minecraft client) {
        long time;
        if (client.f_91073_ != null && Math.abs((time = client.f_91073_.m_46467_()) - this.lastHealthCheckTime) > 1200L) {
            boolean enabled = Config.getInstance().villagerChatAIModel.equals("player2");
            if (this.firstRun || enabled) {
                CompletableFuture.runAsync(() -> {
                    if (this.player2SpeechManager.checkHealth() && this.firstRun && !enabled) {
                        client.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"command.chat_ai.player2.hint", (Object[])new Object[]{"/mca chatAI player2"}));
                        this.firstRun = false;
                    }
                });
            }
            this.lastHealthCheckTime = time;
        }
    }
}

